package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 引用消息
 *
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class QuoteMsg {

    private QuoteAppMsg appmsg;

    @JacksonXmlProperty(localName = "fromusername")
    private String fromUsername;

    private Integer scene;

    @JacksonXmlProperty(localName = "commenturl")
    private String commentUrl;

    @Data
    @EqualsAndHashCode(callSuper = false)
    public static class QuoteAppMsg extends AppMsg {

        private String username;

        private String action;

        @JacksonXmlProperty(localName = "showtype")
        private Integer showType;

        private String content;

        @JacksonXmlProperty(localName = "lowurl")
        private String lowUrl;

        @JacksonXmlProperty(localName = "dataurl")
        private String dataUrl;

        @JacksonXmlProperty(localName = "lowdataurl")
        private String lowDataUrl;

        @JacksonXmlProperty(localName = "refermsg")
        private ReferMsg referMsg;

    }

    @Data
    public static class ReferMsg {

        private Integer type;

        private String svrid;

        private String fromusr;

        private String chatusr;

        private String content;

        @JacksonXmlProperty(localName = "displayname")
        private String displayName;

        @JacksonXmlProperty(localName = "msgsource")
        private String msgSource;
    }

}