/**
 * kuaike.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.util.List;

import lombok.Data;

/**
 * 邀请入群验证
 * 
 * @title ChatRoomAccessVerify
 * @author yanmaoyuan
 * @date 2020年2月17日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "sysmsg")
public class ChatRoomAccessVerify {

    @JacksonXmlProperty(isAttribute = true)
    private String type;

    @JacksonXmlProperty(localName = "NewXmlChatRoomAccessVerifyApplication")
    private VerifyApplication verifyApplication;

    @Data
    public static class VerifyApplication {

        private String text;

        @JacksonXmlProperty(localName = "RoomName")
        private String roomName;

        private Link link;
    }

    @Data
    public static class Link {

        private String scene;

        private String text;

        private String ticket;

        @JacksonXmlProperty(localName = "invitationreason")
        private String invitationReason;// 邀请理由

        @JacksonXmlProperty(localName = "inviterusername")
        private String inviterUsername;// 邀请人的username

        @JacksonXmlProperty(localName = "memberlist")
        private MamberList memberList;
    }

    @Data
    public static class MamberList {

        @JacksonXmlProperty(localName = "memberlistsize")
        private int memberListSize;

        @JacksonXmlProperty(localName = "member")
        @JacksonXmlElementWrapper(useWrapping = false)
        private List<Member> members;
    }

    @Data
    public static class Member {

        private String username;

        private String nickname;

        @JacksonXmlProperty(localName = "headimgurl")
        private String headImgUrl;

        @JacksonXmlProperty(localName = "quitchatroominfo")
        private String quitChatroomInfo;// 曾退出群聊
    }
}