/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.google.common.collect.Sets;

import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @title MsgUtils
 * @author yanmaoyuan
 * @date 2019年12月27日
 * @version 1.0
 */
public class MsgUtils {

    /**
     * 根据内容来判断系统消息的类型
     */
    //通过手机号添加好友话术
    public static final String ADD_FRINED_BY_MOBILE_MESSAGE = "我通过了你的朋友验证请求，现在我们可以开始聊天了";
    
    public static final Pattern FRIEND_IS_JOINED_PATTERN = Pattern.compile("你已添加了(.*?)，现在可以开始聊天了。");

    public static final Pattern JOINED_BY_FRIEND_PATTERN = Pattern.compile("(.*?)刚刚把你添加到通讯录，现在可以开始聊天了。");

    public static final Pattern GROUP_YOU_ARE_OWNER_PATTERN = Pattern.compile("你已成为新群主");

    public static final Pattern GROUP_YOU_ARE_KICKED_PATTERN = Pattern.compile("你被\"(.*?)\"移出群聊");

    public static final Pattern GROUP_STRANGER_PATTERN = Pattern.compile("\"(.*?)\"与群里其他人都不是微信朋友关系，请注意隐私安全");

    /**
     * 用于根据消息内容来判断消息类型
     * 
     * @param message
     * @return
     */
    public static boolean match(String message, Pattern pattern) {
        if (StringUtils.isBlank(message)) {
            return false;
        }

        Matcher matcher = pattern.matcher(message);
        return (matcher.matches());
    }

    /**
     * 从加好友的消息中，提取好友的昵称。
     * 
     * @param text
     * @return
     */
    public static String getJoinFriendNickName(String text) {
        if (MsgUtils.match(text, FRIEND_IS_JOINED_PATTERN)) {
            int begin = "你已添加了".length();
            int end = text.length() - "，现在可以开始聊天了。".length();
            return text.substring(begin, end);
        } else if (MsgUtils.match(text, JOINED_BY_FRIEND_PATTERN)) {
            int begin = 0;
            int end = text.length() - "刚刚把你添加到通讯录，现在可以开始聊天了。".length();
            return text.substring(begin, end);
        }
        return null;
    }

    public static final Pattern AT_MEMBER_PATTERN = Pattern.compile("@.\\S+?[\\s|\\u2005]{1}?|@.\\S+?$");

    /**
     * 移除文本消息中@用户的部分，只保留具体的文本信息。
     * 
     * @param text
     * @return
     */
    public static String removeAtMembers(String text) {
        return StringUtils.defaultIfEmpty(RegExUtils.removeAll(text, AT_MEMBER_PATTERN), "");
    }

    // 这个正则表达式会死循环
    // public static final Pattern REFER_TEXT_PATTERN = Pattern.compile("^「.*(.|\\s|\\r|\\n)*」\\n- - - - - - - - - - - - - - -\\n?");

    /**
     * 移除文本消息中引用其他用户发言的部分，只保留本次消息的内容
     * 
     * @param text
     * @return
     */
    public static String removeReferredText(String text) {
        String HEAD = "「";
        String EOF = "」\n- - - - - - - - - - - - - - -";
        int start = text.indexOf(HEAD);
        int end = text.lastIndexOf(EOF);
        if (start > -1 && end > start) {
            int idx = end + EOF.length();
            if (idx < text.length() && text.charAt(idx) == '\n') {// 移除E后面的\n
                idx++;
            }
            return text.substring(end + EOF.length());
        }
        return text;
    }

    /**
     * 要过滤的微信官方的账号
     */
    public static final Set<String> FILTER_OFFICAL_ACCOUNT = Sets.newHashSet(
            "appbrandcustomerservicemsg", "downloaderapp", "facebookapp",
            "feedsapp", "filehelper", "floatbottle", "fmessag", "lbsapp", "linkedinplugin",
            "masssendapp", "medianote", "newsapp", "notifymessage", "officialaccounts",
            "qqfriend", "qqmail", "shakeapp", "voiceinputapp", "voicevoipapp", "voipapp", "weixin","wechat"
    );

    public static final Pattern OFFICIAL_ACCOUNT_ID = Pattern.compile("^gh_[0-9a-z]{12}$");

    public static final Pattern WEWORK_ID = Pattern.compile("^\\d+@im.chatroom$");

}
