/**
 * Kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.wechat.utils;

import com.google.common.collect.Lists;
import com.kuaike.skynet.logic.wechat.msg.JoinGroupMsg.Member;

import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @title JoinGroupDto
 * @author yanmaoyuan
 * @date 2020年9月16日
 * @version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class JoinGroupDto {

    public final static int INVITE    = 1; // 邀请入群
    public final static int SCAN_CODE = 2; // 扫码进群
    public final static int CREATE    = 3; // 面对面建群

    private int type;

    private Member inviter;

    private List<Member> memberList;

    /**
     * 获取邀请人的微信ID
     * 
     * @return
     */
    public String getInviteWechatId() {
        if (inviter != null) {
            return inviter.getUsername();
        } else {
            return null;
        }
    }

    /**
     * 获取被邀请人的微信ID
     * 
     * @return
     */
    public List<String> getMemberIds() {
        if (CollectionUtils.isNotEmpty(memberList)) {
            return memberList.stream().map(Member::getUsername).collect(Collectors.toList());
        } else {
            return Lists.newArrayList();
        }
    }
}