package com.kuaike.skynet.logic.wechat.msg;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

/**
 * 企业微信个人名片
 */
@Data
@JacksonXmlRootElement(localName = "msg")
public class WeworkCardMsg {

    @JacksonXmlProperty(localName = "bigheadimgurl", isAttribute = true)
    private String bigHeadImgUrl;

    @JacksonXmlProperty(localName = "smallheadimgurl", isAttribute = true)
    private String smallHeadImgUrl;

    @JacksonXmlProperty(isAttribute = true)
    private String username;

    @JacksonXmlProperty(isAttribute = true)
    private String nickname;

    @JacksonXmlProperty(isAttribute = true)
    private Integer sex;

    @JacksonXmlProperty(localName = "openimappid", isAttribute = true)
    private String openImAppId;

    @JacksonXmlProperty(localName = "openimcustominfo", isAttribute = true)
    private String openImCustomInfo;

    @JacksonXmlProperty(isAttribute = true)
    private String ticket;

    @JacksonXmlProperty(localName = "openimdesc", isAttribute = true)
    private String openImDesc;

    @JacksonXmlProperty(localName = "openimdescicon", isAttribute = true)
    private String openImDescIcon;

    @JacksonXmlProperty(localName = "tp_ticket", isAttribute = true)
    private String tpTicket;
}
