/**
 * Kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.enums;

/**
 * @title RcRuleType
 * @author yanmaoyuan
 * @date 2020年7月1日
 * @version 1.0
 */
public enum RcRuleType {

    /**
     * 敏感消息检测，用于防广告
     */
    MESSAGE(1, "message", "群消息检测"),

    /**
     * 群成员昵称检测，用于防范群成员冒充管理员
     */
    NICKNAME(2, "nickname", "群成员昵称检测"),

    /**
     * 私加小号，用于防范竞争对手私下把学员拐走了。
     */
    ADD_ROBOT(3, "addRobot", "私加小号"),

    /**
     * 防骚扰，用于抵抗有人在群里刷屏
     */
    ANTI_HARNESS(4, "antiHarness", "防骚扰"),
    
    /**
     * 防入群，用于防止爆群的人通过不受期望的方式入群
     */
    ANTI_JOIN_GROUP(5, "antiJoinGroup", "防入群"),

    ;

    private int value;

    private String name;

    private String desc;

    private RcRuleType() {}

    /**
     * @param value
     * @param name
     * @param desc
     */
    private RcRuleType(int value, String name, String desc) {
        this.value = value;
        this.name = name;
        this.desc = desc;
    }

    /**
     * @return the value
     */
    public int getValue() {
        return value;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
    
    
}
