/**
 * Kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.enums;

import com.kuaike.common.enums.EnumService;

/**
 * @title RcDealStatus
 * @author yanmaoyuan
 * @date 2020年4月21日
 * @version 1.0
 */
public enum RcDealStatus implements EnumService {

    // 0:待处理
    WAIT(0, "待处理"),
    // 1:处理成功
    SUCCESS(1, "处理成功"),
    // 2:部分成功
    PARTIAL_SUCCESS(2, "部分成功"),
    // 3:失败
    FAILED(3, "失败");

    private int value;

    private String desc;

    private RcDealStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}