package com.kuaike.skynet.rc.service.riskControl.dto.resp;

import lombok.Data;

import java.io.Serializable;

@Data
public class UserQualityCheckRespDto implements Serializable {

    private Long userId;
    private String userName;
    private String deptName;

    /**
     * 新增客户：主动添加好友成功数+被加成为好友数
     */
    private int newCustomerCount;

    /**
     * 跟进客户-新：微信单聊跟进新增客户数（新客户定义是加到好友7天内）
     */
    private int followNewCustomerCount;

    /**
     * 跟进客户-老：微信单聊时跟进老客户数（老客户定义是加到好友超过7天后）
     */
    private int followOldCustomerCount;

    /**
     * 总跟进客户：微信单聊时跟进的新老客户数
     */
    private int followCustomerTotalCount;

    /**
     * 总有效沟通：微信单聊时有效沟通的新增客户加老客户数
     */
    private int effectiveCommunicateTotalCount;

    /**
     * 有效沟通-新：微信单聊有效沟通的新增客户数
     */
    private int effectiveCommunicationNewCount;

    /**
     * 有效沟通-老：微信单聊有效沟通的老客户数
     */
    private int effectiveCommunicationOldCount;

    /**
     * 有效沟通率：新增客户中，微信单聊时有效沟通数/新增客户
     */
    private String effectiveCommunicationRate = "0.0";

    /**
     * 回复时间：微信单聊时回复客户信息的平均时间 (单位为s)
     */
    private int replyTime;

    /**
     * 超时未回复：超时未回复单聊好友的次数
     */
    private int timeoutUnreplyCount;

    /**
     * 删除好友：删除好友的数量
     */
    private int delFriendCount;

    /**
     * 拉黑好友：拉黑好友的数量
     */
    private int blackFriendCount;

    /**
     * 朋友圈：发送朋友圈的次数
     */
    private int sendMomentCount;

    /**
     * 申请通过率：主动申请好友通过数/主动申请
     */
    private String applyPassRate = "0.0";

    /**
     * 被加通过：设置了验证通过的+未设置验证被加为好友的，单向好友也算
     */
    private int passiveAddFriendCount;

    /**
     * 电话通话数：新客户和老客户中，呼出接通和呼入接通的通话个数
     */
    private int phoneCallCount;

    /**
     * 群聊维护数：所有群群主是否有主动发消息，1条信息也算，群主是招生老师本人
     */
    private int chatRoomChatCount;

    /**
     * 群聊维护率：群主发过信息的群/群主所有的群
     */
    private String chatRoomChatRate = "0.0";
}
