package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Data
public class UserQualityCheckListReqDto implements Serializable {

    private Long bizId;

    private Date startDate;
    private Date endDate;

    private List<Long> userIds;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(startDate != null, "开始日期不能为空");
        Preconditions.checkArgument(endDate != null, "开始日期不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(userIds), "用户id集合不能为空");
    }
}
