/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl.dto.req;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 由多个规则组成，但公用一套处理措施的风控规则。例如群消息检测，包含对不同类型的消息检测。
 * 
 * @title RcRuleListDto
 * @author yanmaoyuan
 * @date 2020年6月30日
 * @version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class RcRuleListDto extends RcRuleDto {

    private static final long serialVersionUID = 1L;

    /**
     * 敏感行为检测列表
     */
    private List<RcRuleListItem> list;
}
