package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.rc.service.common.dto.Operator;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class RcResultUndoReq extends Operator {

    private static final long serialVersionUID = 1L;

    /**
     * 风控日志ID
     */
    private Long id;

    /**
     * 撤销原因
     */
    private String reason;

    public void validate() {
        Preconditions.checkArgument(id != null, "id is null");
        Preconditions.checkArgument(StringUtils.isNotBlank(reason), "reason is null or empty");
        Preconditions.checkArgument(reason.length() < 200, "撤销原因过长，不能超过200");
    }
}
