package com.kuaike.skynet.rc.service.riskControl.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.rc.service.common.dto.Operator;
import lombok.Data;

import java.util.Objects;
import java.util.Set;

@Data
public class RcResultDetailReq extends Operator {

    private String rcPlanName; // 风控方案名称

    private String rcPlanCode; // 风控方案编号

    private Set<String> ownerWechatIds; // 群主微信id集合

    /**
     * 处理操作类型 1:拉黑 2:踢出群聊 3:告警 6:踢出群聊并告警
     */
    private Integer dealOpType;

    private PageDto pageDto;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(pageDto), "pageDto not null");
    }
}
