package com.kuaike.skynet.rc.service.riskControl.dto.rclog;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.rc.service.common.dto.Operator;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Objects;
import java.util.Set;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/07/06 10:04
 */
@Data
public class RetryReqDto extends Operator {
    private static final long serialVersionUID = -374619415124841545L;

    private Set<Long> detailIds;

    private Long resultId; //风控日志Id

    public void validate() {
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(detailIds), "detailIds not null");
        Preconditions.checkArgument(Objects.nonNull(resultId), "resultId not null");
    }
}
