package com.kuaike.skynet.rc.service.riskControl;

import com.kuaike.skynet.rc.service.riskControl.dto.req.RobotOwnerChatRoomCountReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.UserQualityCheckListReqDto;
import com.kuaike.skynet.rc.service.riskControl.dto.req.UserQualityCheckReqDto;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.UserQualityCheckRespDto;

import java.util.List;

public interface UserQualityCheckService {

    /**
     * 保存或更新电话通话数、电话通话时长
     * phone_call_count
     */
    void saveOrUpdatePhoneCallInfo(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新消息相关的信息
     * send_msg_count、received_total_count
     */
    void saveOrUpdateMsgInfo(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新超时回复、回复时间相关的信息
     * timeout_unreply_count、reply_count、reply_total_duration
     */
    void saveOrUpdateTimeoutReplyInfo(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新添加好友的信息
     * add_friend_time、passive_add_friend_count
     */
    void saveOrUpdateAddFriendInfo(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新删除好友的信息
     * del_friend_time
     */
    void saveOrUpdateDelFriendInfo(List<UserQualityCheckReqDto> reqDtos);

    /**
     * 保存或更新拉黑好友的信息
     * black_friend_time
     */
    void saveOrUpdateBlackFriendInfo(List<UserQualityCheckReqDto> reqDtos);

    /**
     * 保存或更新机器人发送朋友圈的次数
     */
    void saveOrUpdateSendMomentCount(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新机器人主动申请添加好友的次数
     */
    void saveOrUpdateApplyAddFriendInfo(UserQualityCheckReqDto reqDto);

    /**
     * 保存或更新机器人为群主的群数量
     */
    void saveOrUpdateOwnerChatRoomCount(RobotOwnerChatRoomCountReq reqDto);

    /**
     * 销售质检列表
     */
    List<UserQualityCheckRespDto> list(UserQualityCheckListReqDto reqDto);
}
