/**
 * Kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.rc.service.riskControl;

import com.kuaike.skynet.rc.service.riskControl.dto.req.ChatroomReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanActiveReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcPlanReq;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcDetailDto;

/**
 * 微信群风控方案接口
 * 
 * @title RcPlanChatroomService
 * @author yanmaoyuan
 * @date 2020年7月1日
 * @version 1.0
 */
public interface RcPlanChatroomService {

    /**
     * 根据微信群ID查询风控方案
     * 
     * @param params
     * @return
     */
    RcDetailDto detail(ChatroomReq params);

    /**
     * 新建风控方案
     * 
     * @param param 方案参数
     */
    Long add(RcPlanReq param);

    /**
     * 编辑风控方案
     * 
     * @param param 方案参数
     */
    void modify(RcPlanReq param);

    /**
     * 开启/关闭方案
     * 
     * @param params
     */
    void active(RcPlanActiveReq params);
}