package com.kuaike.skynet.rc.service.riskControl;

import com.kuaike.skynet.rc.service.riskControl.dto.rclog.RetryReqDto;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcResultDetailReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcResultListReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcResultReq;
import com.kuaike.skynet.rc.service.riskControl.dto.req.RcResultUndoReq;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcResultDetailRespDto;
import com.kuaike.skynet.rc.service.riskControl.dto.resp.RcResultListRespDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 风控日志接口
 * 
 * @title RcLogService
 * @author yanmaoyuan
 * @date 2020年7月1日
 * @version 1.0
 */
public interface RcLogService {

    /**
     * 查询风控日志
     * @param req
     * @return
     */
    RcResultListRespDto queryList(RcResultListReq req);

    /**
     * 查看风控日志详情
     * @param req
     * @return
     */
    RcResultDetailRespDto queryResultDetail(RcResultReq req);

    /**
     * 撤销黑名单
     * @param req
     */
    void undoBlacklist(RcResultUndoReq req);

    /**
     * 失败重试
     * @param req
     */
    void retry(RetryReqDto req);

    /**
     * 是否在线
     * @param wechatIds
     * @return
     */
    Map<String, Boolean> onLineByWechatIds(Set<String> wechatIds);

    /**
     * 获取风控结果详情
     */
    RcResultDetailRespDto resultDetailList(RcResultDetailReq req);

    void handleLog(List<Long> rcResultDetailIds);
}
