/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class KeywordUtil {
    public static final int MAX_FUZZY_WORD_COUNNT = 10;

    private KeywordUtil() {
    }

    public static void validateFuzzyKeyword(String word) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)word), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        String[] words = StringUtils.split((String)word, (String)",");
        Preconditions.checkArgument((words != null && words.length > 0 ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((words.length <= 10 ? 1 : 0) != 0, (Object)"\u6a21\u7cca\u5339\u914d\u5206\u8bcd\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
        HashSet wordSet = Sets.newHashSet();
        for (String w : words) {
            Preconditions.checkArgument((boolean)wordSet.add(w), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u91cd\u590d");
        }
    }

    public static String idsToStr(List<? extends Number> labelIds) {
        return Joiner.on((String)",").join(labelIds);
    }

    public static List<String> strToIdsStr(String str) {
        return Splitter.on((String)",").splitToList((CharSequence)str);
    }
}

