/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.dto.label;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.logic.service.common.dto.Operator;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FriendKeywordLabelReq
extends Operator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private List<String> wechatIds;
    private String fuzzyKeyword;
    private String accurateKeyword;
    private List<LabelItemDto> labelItemDtoList;
    private List<Integer> rtypes;

    public void validate() {
        Preconditions.checkArgument((this.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.rtypes), (Object)"rtypes bot null");
        for (Integer rtype : this.rtypes) {
            Preconditions.checkArgument((boolean)Objects.nonNull((Object)FriendMsgReplyType.getType(rtype)), (Object)"rtype illegal");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.getWechatIds()), (Object)"wechatIds\u4e0d\u80fd\u4e3a\u7a7a");
        for (String wechatId : this.wechatIds) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wechatId}), (Object)"wechatId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.rtypes.contains(FriendMsgReplyType.KEYWORD.getValue())) {
            Preconditions.checkArgument((!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.accurateKeyword, this.fuzzyKeyword}) ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotBlank((CharSequence)this.fuzzyKeyword)) {
                KeywordUtil.validateFuzzyKeyword(this.fuzzyKeyword);
            }
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.labelItemDtoList), (Object)"\u9009\u62e9\u7684\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        this.labelItemDtoList.stream().forEach(LabelItemDto::validate);
    }

    public Long getId() {
        return this.id;
    }

    public List<String> getWechatIds() {
        return this.wechatIds;
    }

    public String getFuzzyKeyword() {
        return this.fuzzyKeyword;
    }

    public String getAccurateKeyword() {
        return this.accurateKeyword;
    }

    public List<LabelItemDto> getLabelItemDtoList() {
        return this.labelItemDtoList;
    }

    public List<Integer> getRtypes() {
        return this.rtypes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setWechatIds(List<String> wechatIds) {
        this.wechatIds = wechatIds;
    }

    public void setFuzzyKeyword(String fuzzyKeyword) {
        this.fuzzyKeyword = fuzzyKeyword;
    }

    public void setAccurateKeyword(String accurateKeyword) {
        this.accurateKeyword = accurateKeyword;
    }

    public void setLabelItemDtoList(List<LabelItemDto> labelItemDtoList) {
        this.labelItemDtoList = labelItemDtoList;
    }

    public void setRtypes(List<Integer> rtypes) {
        this.rtypes = rtypes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FriendKeywordLabelReq)) {
            return false;
        }
        FriendKeywordLabelReq other = (FriendKeywordLabelReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<String> this$wechatIds = this.getWechatIds();
        List<String> other$wechatIds = other.getWechatIds();
        if (this$wechatIds == null ? other$wechatIds != null : !((Object)this$wechatIds).equals(other$wechatIds)) {
            return false;
        }
        String this$fuzzyKeyword = this.getFuzzyKeyword();
        String other$fuzzyKeyword = other.getFuzzyKeyword();
        if (this$fuzzyKeyword == null ? other$fuzzyKeyword != null : !this$fuzzyKeyword.equals(other$fuzzyKeyword)) {
            return false;
        }
        String this$accurateKeyword = this.getAccurateKeyword();
        String other$accurateKeyword = other.getAccurateKeyword();
        if (this$accurateKeyword == null ? other$accurateKeyword != null : !this$accurateKeyword.equals(other$accurateKeyword)) {
            return false;
        }
        List<LabelItemDto> this$labelItemDtoList = this.getLabelItemDtoList();
        List<LabelItemDto> other$labelItemDtoList = other.getLabelItemDtoList();
        if (this$labelItemDtoList == null ? other$labelItemDtoList != null : !((Object)this$labelItemDtoList).equals(other$labelItemDtoList)) {
            return false;
        }
        List<Integer> this$rtypes = this.getRtypes();
        List<Integer> other$rtypes = other.getRtypes();
        return !(this$rtypes == null ? other$rtypes != null : !((Object)this$rtypes).equals(other$rtypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FriendKeywordLabelReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<String> $wechatIds = this.getWechatIds();
        result = result * 59 + ($wechatIds == null ? 43 : ((Object)$wechatIds).hashCode());
        String $fuzzyKeyword = this.getFuzzyKeyword();
        result = result * 59 + ($fuzzyKeyword == null ? 43 : $fuzzyKeyword.hashCode());
        String $accurateKeyword = this.getAccurateKeyword();
        result = result * 59 + ($accurateKeyword == null ? 43 : $accurateKeyword.hashCode());
        List<LabelItemDto> $labelItemDtoList = this.getLabelItemDtoList();
        result = result * 59 + ($labelItemDtoList == null ? 43 : ((Object)$labelItemDtoList).hashCode());
        List<Integer> $rtypes = this.getRtypes();
        result = result * 59 + ($rtypes == null ? 43 : ((Object)$rtypes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FriendKeywordLabelReq(super=" + super.toString() + ", id=" + this.getId() + ", wechatIds=" + this.getWechatIds() + ", fuzzyKeyword=" + this.getFuzzyKeyword() + ", accurateKeyword=" + this.getAccurateKeyword() + ", labelItemDtoList=" + this.getLabelItemDtoList() + ", rtypes=" + this.getRtypes() + ")";
    }
}

