package com.kuaike.skynet.logic.service.wechat.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;


/**
 * @description: 被动添加好友新增或更新Dto
 * @author: liuguohong
 * @create: 2019/10/28 10:40
 */
@Data
public class PassiveAddFriendModelDto implements Serializable {
    private static final long serialVersionUID = 2972880838845815767L;
    private Long id; //配置的Id
    private Long operatorId; //操作者Id
    private String wechatId; //微信号
    private Boolean passiveAddFriendCheckFlag; //被动添加好友是否通过，true：通过，false:否
    private Boolean weworkAddFriendFlag; // 是否去企业微信添加对方 true:是 false:否

    public void validate() {
        Preconditions.checkNotNull(operatorId, "operatorId is not null");
        Preconditions.checkNotNull(passiveAddFriendCheckFlag, "passiveAddFriendCheckFlag is not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(wechatId), "wechatId is not null");
    }
}
