/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.wechat.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.service.common.dto.Operator;

import java.util.Date;
import java.util.Set;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 好友自动备注列表查询参数
 * 
 * @title AutoRemarkFriendListReq
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class AutoRemarkFriendListReq extends Operator {

    private static final long serialVersionUID = 1L;
    //微信昵称微信号搜索
    private String query;

    // 微信筛选条件 (可不传)
    /**
     * 微信号或昵称
     */
    private String wechatId;

    /**
     * 用户有权管辖的用户id集合
     */
    private Set<Long> userIds;

    // 有效期筛选条件 (可不传)
    /**
     * 有效期开始时间
     */
    private Date effectiveStartTime;

    /**
     * 有效期截止时间
     */
    private Date effectiveEndTime;

    // 更新人筛选条件 (可不传)
    /**
     * 更新人的用户名或昵称
     */
    private Long userId;

    // 更新时间筛选条件 (可不传)
    
    /**
     * 更新开始时间
     */
    private Date updateStartTime;

    /**
     * 更新截止时间
     */
    private Date updateEndTime;

    private Integer timeSort; //0:正排，1：倒排

    private PageDto pageDto;
}