/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.wechat;

import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendDetailReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendEditReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendListReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendToggleReq;
import com.kuaike.skynet.logic.service.wechat.dto.resp.AutoRemarkFriendListResp;
import com.kuaike.skynet.logic.service.wechat.dto.resp.AutoRemarkFriendDetailRespDto;

/**
 * 添加好友自动备注
 * 
 * 这个接口用于定义微信号在同意好友申请后的行为：自动对好友进行备注，备注的内容和格式由本接口来控制。
 * 
 * @title AutoRemarkFriendService
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
public interface WechatAutoRemarkFriendService {

    /**
     * 编辑好友自动备注
     * 
     * @param params
     * @return 保存成功，返回记录ID
     */
    Long addOrMod(AutoRemarkFriendEditReq params);

    /**
     * 查询好友自动备注
     * 
     * @param params
     * @return 返回微信列表
     */
    AutoRemarkFriendListResp list(AutoRemarkFriendListReq params);

    /**
     * 查看自动备注详情
     * 
     * @param params
     * @return 返回配置详情
     */
    AutoRemarkFriendDetailRespDto detail(AutoRemarkFriendDetailReq params);

    /**
     * 开启、关闭自动备注
     * 
     * @param params
     * @return 返回此操作后的配置开关状态
     */
    Boolean toggle(AutoRemarkFriendToggleReq params);
}