package com.kuaike.skynet.logic.service.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import static com.kuaike.skynet.logic.service.constans.LogicConf.KEYWORD_DELIMITER;

/**
 * @description:
 * @author: liuguohong
 * @create: 2021/03/01 10:50
 */

public final class KeywordUtil {
    /**
     * 一条自动回复中，最多可以设置多少个模糊匹配的关键词?
     */
    public final static int MAX_FUZZY_WORD_COUNNT = 10;
    private KeywordUtil() {

    }
    public static void validateFuzzyKeyword(String word) {
        Preconditions.checkArgument(StringUtils.isNotBlank(word), "关键词不能为空");

        // 模糊匹配关键词校验
        String[] words = StringUtils.split(word, ",");
        Preconditions.checkArgument(words != null && words.length > 0, "关键词不能为空");
        Preconditions.checkArgument(words.length <= MAX_FUZZY_WORD_COUNNT, "模糊匹配分词不能超过" + MAX_FUZZY_WORD_COUNNT + "个");

        Set<String> wordSet = Sets.newHashSet();
        for (String w : words) {
            Preconditions.checkArgument(wordSet.add(w), "关键词不能重复");
        }
    }

    /**
     * 以KEYWORD_DELIMITER分割数字转成String
     * @param labelIds
     * @return
     */
    public static String idsToStr(List<? extends Number> labelIds) {
        return Joiner.on(KEYWORD_DELIMITER).join(labelIds);
    }

    public static List<String> strToIdsStr(String str) {
        return Splitter.on(KEYWORD_DELIMITER).splitToList(str);
    }
}
