/**
 * kuaike.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 关键词匹配模式
 * 
 * @title KeywordMatchType
 * @author yanmaoyuan
 * @date 2020年4月16日
 * @version 1.0
 */
public enum KeywordMatchType implements EnumService {

    ACCURATE(1, "精确匹配"),

    FUZZY(2, "模糊匹配");

    private static final Map<Integer, KeywordMatchType> CACHE = new HashMap<>();

    static {
        for (KeywordMatchType e : values()) {
            CACHE.put(e.value, e);
        }
    }

    private final int value;

    private final String desc;

    private KeywordMatchType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static KeywordMatchType getType(int value) {
        return CACHE.get(value);
    }

    public static Integer getValueByDesc(String desc) {
        for (KeywordMatchType type : CACHE.values()) {
            if (type.getDesc().equals(desc)) {
                return type.getValue();
            }
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        KeywordMatchType type = getType(value);
        if (type != null) {
            return type.getDesc();
        } else {
            return null;
        }
    }
}