/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.resp;

import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 查询微信好友私聊关键词回复详情
 * 
 * @title FriendKeywordReplyDetailResp
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
public class FriendKeywordReplyDetailResp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一ID
     */
    private Long id;

    private Integer rtype;

    /**
     * 关键词
     */
    private AutoReplyWordDto keyWord;

    /**
     * 问题
     */
    private String request;
    
    /**
     * 回复内容
     */
    private List<AutoReplyMessageDto> replyMessage;

    /**
     * 适用微信号
     */
    private List<WechatResp> applyScopeList;

    /**
     * 最后更新人的信息，可能为null
     */
    private OperatorResp updator;
}