package com.kuaike.skynet.logic.service.reply.dto.req;

import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType.CHAT_ROOM;
import static com.kuaike.skynet.logic.service.reply.enums.AutoReplyType.JOIN_GROUP_REPLY;

import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;

import java.util.Collection;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @Classname JoinGroupReplyReqDto
 * @Description
 * @Date 2019/6/17 上午11:25
 * @Created by guokaijun
 */
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
public class JoinGroupReplyReqDto extends LogicReplyDto {
    private static final long serialVersionUID = 1764950741604780790L;

    private Collection<RobotToRoomDto> chatRooms;

    public JoinGroupReplyReqDto() {
        super(CHAT_ROOM, JOIN_GROUP_REPLY);
    }

    // 入群回复时间间隔最小值
    private Integer timeIntervalMin;

    // 入群回复时间间隔最大值
    private Integer timeIntervalMax;

    // 入群回复人数间隔
    private Integer memberInterval;
}