package com.kuaike.skynet.logic.service.reply.dto.label;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Objects;

/**
 * @description:
 * @author: liuguohong
 * @create: 2021/02/28 18:17
 */
@Data
@EqualsAndHashCode
public class LabelItemDto implements Serializable {
    private static final long serialVersionUID = 1L;
    //标签Id
    private Long labelId;
    //流量等级
    private Long flowLevelId;

    private String labelName;
    private Integer flowLevel;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(labelId), "labelId not null");
        Preconditions.checkArgument(Objects.nonNull(flowLevelId), "flowLevelId not null");
    }
}
