package com.kuaike.skynet.logic.service.reply.dto.label;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.logic.service.common.dto.Operator;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author: liuguohong
 * @create: 2021/02/28 17:58
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class FriendKeywordLabelReq extends Operator implements Serializable {
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 微信号
     */
    private List<String> wechatIds;

    /**
     * 模糊匹配关键词，多个关键词使用","分割
     */
    private String fuzzyKeyword;

    /**
     * 精确匹配关键词，多个关键词使用","分割
     */
    private String accurateKeyword;

    private List<LabelItemDto> labelItemDtoList;

    /**
     * 1-文本(关键词),3-图片,4-视频,5-语音,6-文件
     *
     * @see com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType
     */
    private List<Integer> rtypes;

    /**
     * 参数校验
     */
    public void validate() {
        Preconditions.checkArgument(this.getOperatorId() != null, "operatorId不能为空");
        Preconditions.checkArgument(this.getBusinessCustomerId() != null, "merchantId不能为空");
        Preconditions.checkArgument(this.getNodeId() != null, "nodeId不能为空");

        Preconditions.checkArgument(CollectionUtils.isNotEmpty(rtypes), "rtypes bot null");
        for (Integer rtype : rtypes) {
            Preconditions.checkArgument(Objects.nonNull(FriendMsgReplyType.getType(rtype)), "rtype illegal");
        }

        // 校验适用的微信号
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(this.getWechatIds()), "wechatIds不能为空");
        for (String wechatId : wechatIds) {
            Preconditions.checkArgument(StringUtils.isNoneBlank(wechatId), "wechatId不能为空");
        }
        if (rtypes.contains(FriendMsgReplyType.KEYWORD.getValue())) {
            Preconditions.checkArgument(!StringUtils.isAllBlank(accurateKeyword, fuzzyKeyword), "关键词设置不能为空");
            if (StringUtils.isNotBlank(fuzzyKeyword)) {
                KeywordUtil.validateFuzzyKeyword(fuzzyKeyword);
            }
        }

        Preconditions.checkArgument(CollectionUtils.isNotEmpty(labelItemDtoList), "选择的标签不能为空");
        labelItemDtoList.stream().forEach(LabelItemDto::validate);
    }
}
