/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto.label;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.service.common.dto.Operator;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 查询微信好友关键词回复的参数
 * 
 * @title FriendKeywordReplyListReqDto
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class FriendKeywordLabelListReq extends Operator {

    private static final long serialVersionUID = 1L;

    // 关键词筛选条件 (可不传)
    /**
     * 关键词
     */
    private String keywordQuery;

    // 微信筛选条件 (可不传)
    /**
     * 微信号
     */
    private String wechatId;
    /**
     * 微信号昵称模糊匹配
     */
    private String query;

    // 更新人筛选条件 (可不传)
    /**
     * 更新人
     */
    private Long userId;

    /**
     * 按更新时间排序，0-升序，1-降序
     */
    private Integer timeSort = 1;

    /**
     * 分页查询参数 (可不传)
     */
    private PageDto pageDto;
}
