package com.kuaike.skynet.logic.service.reply.dto;

import com.kuaike.skynet.logic.service.reply.dto.resp.ChatroomRespDto;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @Classname AutoReplyMessageDto
 * @Description
 * @Date 2019/6/17 上午11:45
 * @Created by guokaijun
 */
@Data
public class  AutoReplyMessageDto implements Serializable {
    private static final long serialVersionUID = -2739951947931319110L;

    // 延迟发送(单位:秒)
    private Integer delay = 0;
    
    /** 类型 0、素材 1、文字 2、图片 */
    private Integer type;

    /** 消息内容 */
    private String message;

    /** 顺序 */
    private Integer seq;

    /** 素材Id */
    private Long materialId;

    /**
     * 小程序ID
     */
    private Long miniProgramId;

    /**
     * 群裂变ID
     */
    private Long fissionId;

    /**
     * 流量漏斗(群引流)ID
     */
    private Long drainageId;

    /**
     * 当群成员数达到此上限后，自动使用备用群。
     */
    private Integer chatroomMaxMemberCount;

    /**
     * 加群卡片对应的群ID
     */
    private List<RobotToRoomDto> list;

    /**
     * 个人名片
     */
    private List<BcardDto> cards;

    /**
     * 邀请入群的群ID
     * 
     * @deprecated 1.6.3 废弃
     */
    @Deprecated
    private List<String> chatroomIds;

    /**
     * 用于显示的群信息
     * @deprecated 1.6.3 废弃
     */
    @Deprecated
    private List<ChatroomRespDto> chatroomList;

    /**
     * 公众号图文
     */
    private Long officialNewsId;

    /**
     * 公众号裂变
     */
    private Long officialActiId;

    /** 素材标题 */
    private String title;

    // 链接描述
    private String desc;

    // 链接地址
    private String url;

    // 语音、视频的时常
    private Integer duration;

    // 缩略图地址
    private String thumbUrl;

    // 小程序图标地址
    private String iconUrl;

    // 小程序页面路径
    private String pagepath;

    private String appId;

    private String username;

    private String nickname;

    /** 素材文件类型 */
    private String mType;

    /**
     * 获取消息延迟发送的时间(单位:秒)
     * 
     * 为了防止异常，这里会有默认值0。
     * @return
     */
    public int getDelay() {
        if (delay == null || delay < 0) {
            return 0;
        }
        
        return delay;
    }

    /**
     * 设置延迟发送时间
     * 
     * @param delay
     */
    public void setDelay(Integer delay) {
        if (delay == null) {
            delay = 0;
        }
        this.delay = delay;
    }
}
