package com.kuaike.skynet.logic.service.reply;

import com.kuaike.common.exception.BusinessException;
import com.kuaike.skynet.logic.service.reply.dto.LogicReplyDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyEnabledReq;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyRoomWechatResp;

import java.util.List;

/**
 * @Classname ReplyService
 * @Description 非关键词自动回复服务
 * @Date 2019/4/29 下午1:47
 * @Created by guokaijun
 */
public interface ReplyService {
    ReplyListRespDto list(ReplyListReqDto reqDto) throws IllegalArgumentException, BusinessException;

    void addOrMod(LogicReplyDto reqDto) throws IllegalArgumentException, BusinessException;
    
    boolean checkReply(LogicReplyDto req) throws IllegalArgumentException, BusinessException;

    void delete(ReplyIdReqDto reqDto) throws IllegalArgumentException, BusinessException;

    ReplyListResp detail(ReplyIdReqDto reqDto) throws IllegalArgumentException, BusinessException;

    /**
     * 启用/禁用
     * @param reqDto
     */
    void enabled(ReplyEnabledReq reqDto);

    List<ReplyRoomWechatResp> queryReplyWechatRoom(List<String> roomIds);
}