/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply;

import com.kuaike.skynet.logic.service.reply.dto.req.BatchMarketWordReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.BatchMarketWordReplyRespDto;

/**
 * 营销活动关键词回复
 * 
 * @title MarketKeywordReplyService
 * @author yanmaoyuan
 * @date 2020年4月16日
 * @version 1.0
 */
public interface MarketKeywordReplyService {

    /**
     * 查询列表
     * 
     * @param params
     * @return
     */
    BatchMarketWordReplyRespDto query(ReplyListReqDto params);

    /**
     * 编辑关键词
     * 
     * @param params
     */
    void modify(BatchMarketWordReplyReqDto params);

    /**
     * 删除营销方案的所有关键词回复
     * 
     * @param params
     */
    void deleteAll(BatchMarketWordReplyReqDto params);
}
