/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply;

import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;

import java.util.List;

/**
 * 这个Dubbo接口用于对AutoReplyMessageDto对象进行操作，用于数据回填显示等前端需求。
 * 
 * @title LogicReplyMsgDtoService
 * @author yanmaoyuan
 * @date 2020年3月3日
 * @version 1.0
 */
public interface LogicReplyMsgDtoService {

    /**
     * 将CommonMessage中的message字符串解码，转义成AutoReplyMessageDto。
     * 
     * @param list
     * @return
     */
    List<AutoReplyMessageDto> fromCommonMessage(List<CommonMessage> list);

    /**
     * 向消息中填充素材、裂变、等消息内容。
     * 
     * @param list
     * @return
     */
    List<AutoReplyMessageDto> fillAutoReplyMessageDto(List<AutoReplyMessageDto> list);
}