/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.common.dto;

import java.io.Serializable;
import java.util.Collection;

import lombok.Data;

/**
 * 操作者信息
 * 
 * 通过接口查询数据时，业务上可能需要根据操作者信息进行权限控制，这个类用于表示操作者的身份信息。
 * 
 * @title Operator
 * @author yanmaoyuan
 * @date 2019年12月13日
 * @version 1.0
 */
@Data
public class Operator implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 操作人id */
    private Long operatorId;

    /** 商户id */
    private Long businessCustomerId;

    /** 部门id */
    private Long nodeId;

    /**
     * 用户有管理权限的部门id
     */
    private Collection<Long> nodeIds;
}
