/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.market.entity.DrainagePlan;
import com.kuaike.skynet.logic.dal.market.entity.FissionPlan;
import com.kuaike.skynet.logic.dal.material.entity.SmallRoutine;
import com.kuaike.skynet.logic.dal.material.mapper.SmallRoutineMapper;
import com.kuaike.skynet.logic.dal.official.dto.OfficialNewsMaterialDto;
import com.kuaike.skynet.logic.dal.official.entity.OfficialActi;
import com.kuaike.skynet.logic.dal.official.mapper.OfficialActiMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccount;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatContact;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatContactMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatIconMapper;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.marketing.DrainagePlanService;
import com.kuaike.skynet.logic.service.marketing.FissionPlanService;
import com.kuaike.skynet.logic.service.material.MaterialService;
import com.kuaike.skynet.logic.service.material.NewsMaterialCommonService;
import com.kuaike.skynet.logic.service.material.dto.MaterialDto;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.BcardDto;
import com.kuaike.skynet.logic.service.reply.dto.ContactBcardDto;
import com.kuaike.skynet.logic.service.reply.dto.FileDto;
import com.kuaike.skynet.logic.service.reply.dto.ReplyJoinGroupCardDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;
import com.kuaike.skynet.logic.service.reply.dto.ShareLinkDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ChatroomRespDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReplyMessageDtoServiceImpl
implements ReplyMessageDtoService {
    private static final Logger log = LoggerFactory.getLogger(ReplyMessageDtoServiceImpl.class);
    @Autowired
    private MaterialService materialService;
    @Autowired
    private NewsMaterialCommonService newsMaterialCommonService;
    @Autowired
    private DrainagePlanService drainagePlanService;
    @Autowired
    private FissionPlanService fissionPlanService;
    @Autowired
    private SmallRoutineMapper smallRoutineMapper;
    @Autowired
    private OfficialActiMapper officialActiMapper;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private WechatIconMapper wechatIconMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private WechatContactMapper wechatContactMapper;

    @Override
    public String toReplyMessageStr(Collection<AutoReplyMessageDto> list) {
        ReplyMessageDto messageDto = this.toReplyMessageDto(list);
        return JacksonUtil.obj2Str((Object)messageDto);
    }

    @Override
    public ReplyMessageDto toReplyMessageDto(String replyMessage) {
        ReplyMessageDto messageDto = null;
        try {
            messageDto = (ReplyMessageDto)JacksonUtil.str2Obj((String)replyMessage, ReplyMessageDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing replyMessage, message={}", (Object)replyMessage, (Object)e);
        }
        return messageDto;
    }

    @Override
    public ReplyMessageDto toReplyMessageDto(Collection<AutoReplyMessageDto> list) {
        ArrayList<AutoReplyMessageDto> messageDtos = new ArrayList<AutoReplyMessageDto>(list);
        ArrayList<CommonMessage> commonMessages = new ArrayList<CommonMessage>(list.size());
        for (int i = 0; i < messageDtos.size(); ++i) {
            AutoReplyMessageDto dto = (AutoReplyMessageDto)messageDtos.get(i);
            AutoReplyMessageType type = AutoReplyMessageType.getType((Integer)dto.getType());
            if (type == null) {
                type = AutoReplyMessageType.TEXT;
                log.warn("Unknown msg type, msg={}", (Object)dto);
            }
            CommonMessage message = new CommonMessage();
            message.setDelay(Integer.valueOf(dto.getDelay()));
            message.setSeq(Integer.valueOf(i + 1));
            message.setType(dto.getType());
            switch (type) {
                case MATERIAL: {
                    Preconditions.checkArgument((dto.getMaterialId() != null ? 1 : 0) != 0, (Object)"\u7d20\u6750\u7684\u7d20\u6750id\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getMaterialId().toString());
                    break;
                }
                case TEXT: {
                    message.setContent(dto.getMessage());
                    break;
                }
                case IMAGE: {
                    message.setContent(dto.getMessage());
                    break;
                }
                case VIDEO: {
                    message.setContent(dto.getMessage());
                    break;
                }
                case VOICE: {
                    message.setContent(dto.getMessage());
                    break;
                }
                case FILE: {
                    Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTitle()}), (Object)"\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getUrl()}), (Object)"\u6587\u4ef6\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                    FileDto file = new FileDto();
                    file.setTitle(dto.getTitle());
                    file.setUrl(dto.getUrl());
                    message.setContent(JacksonUtil.obj2Str((Object)file));
                    break;
                }
                case LINK: {
                    Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getTitle()}), (Object)"\u94fe\u63a5\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getDesc()}), (Object)"\u94fe\u63a5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getUrl()}), (Object)"\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                    ShareLinkDto link = new ShareLinkDto();
                    link.setTitle(dto.getTitle());
                    link.setDesc(dto.getDesc());
                    link.setUrl(dto.getUrl());
                    link.setThumbUrl(dto.getThumbUrl());
                    message.setContent(JacksonUtil.obj2Str((Object)link));
                    break;
                }
                case DRAINAGE: {
                    Preconditions.checkArgument((dto.getDrainageId() != null ? 1 : 0) != 0, (Object)"\u6d41\u91cf\u6f0f\u6597ID\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getDrainageId().toString());
                    break;
                }
                case FISSION: {
                    Preconditions.checkArgument((dto.getFissionId() != null ? 1 : 0) != 0, (Object)"\u7fa4\u88c2\u53d8ID\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getFissionId().toString());
                    break;
                }
                case JOIN_GROUP_CARD: {
                    Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)dto.getList()), (Object)"\u7fa4\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    Object card = new ReplyJoinGroupCardDto();
                    ((ReplyJoinGroupCardDto)card).setChatroomIds(dto.getChatroomIds());
                    ((ReplyJoinGroupCardDto)card).setList(dto.getList());
                    ((ReplyJoinGroupCardDto)card).setChatroomMaxMemberCount(dto.getChatroomMaxMemberCount());
                    message.setContent(JacksonUtil.obj2Str((Object)card));
                    break;
                }
                case CONTACT_BCARD: {
                    Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCards()), (Object)"\u4e2a\u4eba\u540d\u7247\u4e0d\u80fd\u4e3a\u7a7a");
                    Object card = new ContactBcardDto();
                    ((ContactBcardDto)card).setList(dto.getCards());
                    message.setContent(JacksonUtil.obj2Str((Object)card));
                    break;
                }
                case MINI_PROGRAM: {
                    Preconditions.checkArgument((dto.getMiniProgramId() != null ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8fID\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getMiniProgramId().toString());
                    break;
                }
                case OFFICIAL_NEWS: {
                    Preconditions.checkArgument((dto.getOfficialNewsId() != null ? 1 : 0) != 0, (Object)"\u516c\u4f17\u53f7\u56fe\u6587ID\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getOfficialNewsId().toString());
                    break;
                }
                case OFFICIAL_ACTI: {
                    Preconditions.checkArgument((dto.getOfficialActiId() != null ? 1 : 0) != 0, (Object)"\u516c\u4f17\u53f7\u88c2\u53d8ID\u4e0d\u80fd\u4e3a\u7a7a");
                    message.setContent(dto.getOfficialActiId().toString());
                    break;
                }
                default: {
                    log.warn("Unknown reply type: dto={}", (Object)dto);
                    message.setContent(dto.getMessage());
                }
            }
            commonMessages.add(message);
        }
        return new ReplyMessageDto(commonMessages);
    }

    @Override
    public List<AutoReplyMessageDto> toAutoReplyMessageDtoList(LogicAutoReply reply) {
        log.debug("Convert reply message to AutoReplyMessageDto list, id={}, message={}", (Object)reply.getId(), (Object)reply.getMessage());
        ReplyMessageDto messageDto = null;
        try {
            messageDto = (ReplyMessageDto)JacksonUtil.str2Obj((String)reply.getMessage(), ReplyMessageDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing replyMessage, id={}", (Object)reply.getId(), (Object)e);
            return Collections.emptyList();
        }
        List<AutoReplyMessageDto> list = this.parseAutoReplyMessageDtoList(messageDto);
        this.fillAutoReplyMessageDtoList(list);
        return list;
    }

    @Override
    public List<AutoReplyMessageDto> parseAutoReplyMessageDtoList(LogicAutoReply reply) {
        if (reply == null || StringUtils.isBlank((CharSequence)reply.getMessage())) {
            return Collections.emptyList();
        }
        log.debug("Convert reply message to AutoReplyMessageDto list, id={}, message={}", (Object)reply.getId(), (Object)reply.getMessage());
        ReplyMessageDto messageDto = null;
        try {
            messageDto = (ReplyMessageDto)JacksonUtil.str2Obj((String)reply.getMessage(), ReplyMessageDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing replyMessage, id={}", (Object)reply.getId(), (Object)e);
            return Collections.emptyList();
        }
        return this.parseAutoReplyMessageDtoList(messageDto);
    }

    @Override
    public List<AutoReplyMessageDto> parseAutoReplyMessageDtoList(String replyMessage) {
        log.debug("Convert reply message to AutoReplyMessageDto list, message={}", (Object)replyMessage);
        if (StringUtils.isBlank((CharSequence)replyMessage)) {
            log.info("ReplyMessage is empty. replyMessage={}", (Object)replyMessage);
            return Collections.emptyList();
        }
        ReplyMessageDto messageDto = null;
        try {
            messageDto = (ReplyMessageDto)JacksonUtil.str2Obj((String)replyMessage, ReplyMessageDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing replyMessage, message={}", (Object)replyMessage, (Object)e);
            return Collections.emptyList();
        }
        return this.parseAutoReplyMessageDtoList(messageDto);
    }

    @Override
    public List<AutoReplyMessageDto> parseAutoReplyMessageDtoList(ReplyMessageDto replyMessageDto) {
        if (replyMessageDto == null || CollectionUtils.isEmpty((Collection)replyMessageDto.getReplyMessage())) {
            log.warn("ReplyMessage id empty");
            return Collections.emptyList();
        }
        ArrayList<AutoReplyMessageDto> messageDtos = new ArrayList<AutoReplyMessageDto>();
        for (CommonMessage commonMessage : replyMessageDto.getReplyMessage()) {
            if (commonMessage == null) {
                log.warn("CommonMessage is null, replyMessage={}", (Object)replyMessageDto);
                continue;
            }
            AutoReplyMessageDto dto = new AutoReplyMessageDto();
            dto.setDelay(Integer.valueOf(commonMessage.getDelay()));
            dto.setType(commonMessage.getType());
            dto.setSeq(commonMessage.getSeq());
            AutoReplyMessageType type = AutoReplyMessageType.getType((Integer)dto.getType());
            if (type == null) {
                log.warn("Unknown msg type, msg={}", (Object)dto);
                type = AutoReplyMessageType.TEXT;
            }
            switch (type) {
                case MATERIAL: {
                    Long materialId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setMaterialId(materialId);
                    break;
                }
                case TEXT: {
                    dto.setMessage(commonMessage.getContent());
                    break;
                }
                case IMAGE: {
                    dto.setMessage(commonMessage.getContent());
                    break;
                }
                case VIDEO: {
                    dto.setMessage(commonMessage.getContent());
                    break;
                }
                case VOICE: {
                    dto.setMessage(commonMessage.getContent());
                    break;
                }
                case FILE: {
                    FileDto file = null;
                    try {
                        file = (FileDto)JacksonUtil.str2Obj((String)commonMessage.getContent(), FileDto.class);
                    }
                    catch (IOException e) {
                        log.error("Failed parsing file, content={}", (Object)commonMessage.getContent(), (Object)e);
                        e.printStackTrace();
                    }
                    if (file == null) break;
                    dto.setTitle(file.getTitle());
                    dto.setUrl(file.getUrl());
                    break;
                }
                case LINK: {
                    ShareLinkDto link = null;
                    try {
                        link = (ShareLinkDto)JacksonUtil.str2Obj((String)commonMessage.getContent(), ShareLinkDto.class);
                    }
                    catch (IOException e) {
                        log.error("Failed parsing link, content={}", (Object)commonMessage.getContent(), (Object)e);
                        e.printStackTrace();
                    }
                    if (link == null) break;
                    dto.setTitle(link.getTitle());
                    dto.setDesc(link.getDesc());
                    dto.setUrl(link.getUrl());
                    dto.setThumbUrl(link.getThumbUrl());
                    break;
                }
                case DRAINAGE: {
                    Long drainageId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setDrainageId(drainageId);
                    break;
                }
                case FISSION: {
                    Long fissionId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setFissionId(fissionId);
                    break;
                }
                case JOIN_GROUP_CARD: {
                    dto.setTitle("\u52a0\u7fa4\u5361\u7247");
                    Object card = null;
                    try {
                        card = (ReplyJoinGroupCardDto)JacksonUtil.str2Obj((String)commonMessage.getContent(), ReplyJoinGroupCardDto.class);
                    }
                    catch (IOException e) {
                        log.error("Failed parsing join group card, content={}", (Object)commonMessage.getContent(), (Object)e);
                        e.printStackTrace();
                    }
                    if (card == null) break;
                    dto.setChatroomMaxMemberCount(((ReplyJoinGroupCardDto)card).getChatroomMaxMemberCount());
                    dto.setChatroomIds(((ReplyJoinGroupCardDto)card).getChatroomIds());
                    dto.setList(((ReplyJoinGroupCardDto)card).getList());
                    break;
                }
                case OWNER_BCARD: {
                    dto.setTitle("\u7fa4\u4e3b\u4e2a\u4eba\u540d\u7247");
                    break;
                }
                case CONTACT_BCARD: {
                    dto.setTitle("\u4e2a\u4eba\u540d\u7247");
                    Object card = null;
                    try {
                        card = (ContactBcardDto)JacksonUtil.str2Obj((String)commonMessage.getContent(), ContactBcardDto.class);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        log.error("Failed parsing contact business card, content={}", (Object)commonMessage.getContent(), (Object)e);
                    }
                    if (card == null) break;
                    dto.setCards(((ContactBcardDto)card).getList());
                    break;
                }
                case MINI_PROGRAM: {
                    Long miniProgramId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setMiniProgramId(miniProgramId);
                    break;
                }
                case OFFICIAL_NEWS: {
                    Long officialNewsId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setOfficialNewsId(officialNewsId);
                    break;
                }
                case OFFICIAL_ACTI: {
                    Long officialActiId = ReplyMessageDtoServiceImpl.parseLong(commonMessage.getContent());
                    dto.setOfficialActiId(officialActiId);
                    break;
                }
                default: {
                    dto.setMessage(commonMessage.getContent());
                }
            }
            messageDtos.add(dto);
        }
        return messageDtos;
    }

    @Override
    public List<AutoReplyMessageDto> fillAutoReplyMessageDtoList(List<AutoReplyMessageDto> list) {
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashSet<Long> drainageIdSet = new HashSet<Long>();
        HashSet<Long> fissionIdSet = new HashSet<Long>();
        HashSet<Long> miniProgramIdSet = new HashSet<Long>();
        HashSet<Long> officialNewsIdSet = new HashSet<Long>();
        HashSet<Long> officialActiIdSet = new HashSet<Long>();
        HashSet wechatIdSet = new HashSet();
        HashSet contactIdSet = new HashSet();
        HashSet chatroomIdSet = new HashSet();
        for (AutoReplyMessageDto dto : list) {
            AutoReplyMessageType type = AutoReplyMessageType.getType((Integer)dto.getType());
            if (type == null) {
                log.warn("Unknown msg type, msg={}", (Object)dto);
                continue;
            }
            switch (type) {
                case MATERIAL: {
                    materialIdSet.add(dto.getMaterialId());
                    break;
                }
                case DRAINAGE: {
                    drainageIdSet.add(dto.getDrainageId());
                    break;
                }
                case FISSION: {
                    fissionIdSet.add(dto.getFissionId());
                    break;
                }
                case OFFICIAL_NEWS: {
                    officialNewsIdSet.add(dto.getOfficialNewsId());
                    break;
                }
                case OFFICIAL_ACTI: {
                    officialActiIdSet.add(dto.getOfficialActiId());
                    break;
                }
                case JOIN_GROUP_CARD: {
                    if (CollectionUtils.isNotEmpty((Collection)dto.getChatroomIds())) {
                        chatroomIdSet.addAll(dto.getChatroomIds());
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)dto.getList())) break;
                    dto.getList().forEach(it -> {
                        wechatIdSet.add(it.getWechatId());
                        chatroomIdSet.addAll(it.getChatroomIds());
                    });
                    break;
                }
                case CONTACT_BCARD: {
                    if (!CollectionUtils.isNotEmpty((Collection)dto.getCards())) break;
                    dto.getCards().forEach(it -> {
                        wechatIdSet.add(it.getRobotId());
                        contactIdSet.add(it.getWechatId());
                    });
                    break;
                }
                case MINI_PROGRAM: {
                    miniProgramIdSet.add(dto.getMiniProgramId());
                    break;
                }
            }
        }
        Map<Object, Object> materialDtoMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(materialIdSet)) {
            List materialDtos = this.materialService.getMaterials(new ArrayList(materialIdSet));
            materialDtoMap = materialDtos.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<Object, Object> drainageMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(drainageIdSet)) {
            List drainageList = this.drainagePlanService.queryByIds(drainageIdSet);
            drainageMap = drainageList.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<Object, Object> fissionMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(fissionIdSet)) {
            List fissionList = this.fissionPlanService.queryByIds(fissionIdSet);
            fissionMap = fissionList.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<Object, Object> miniProgramMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(miniProgramIdSet)) {
            List miniProgramList = this.smallRoutineMapper.queryByIds(miniProgramIdSet);
            miniProgramMap = miniProgramList.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<Object, Object> newsDtoMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(officialNewsIdSet)) {
            List newsDtoList = this.newsMaterialCommonService.queryOfficialMaterialInfoByIds(officialNewsIdSet);
            newsDtoMap = newsDtoList.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<Object, Object> offcialActiMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(officialActiIdSet)) {
            List officialActiList = this.officialActiMapper.queryByIds(officialActiIdSet);
            offcialActiMap = officialActiList.stream().collect(Collectors.toMap(it -> it.getId(), Function.identity()));
        }
        Map<String, List<WechatChatRoom>> chatRoomMap = Collections.emptyMap();
        Map<String, List<WechatChatRoom>> robotToRoomMap = Collections.emptyMap();
        Map iconMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(chatroomIdSet)) {
            iconMap = this.wechatIconMapper.queryIconByWechatIds(chatroomIdSet);
            List chatRoomList = this.wechatChatRoomMapper.queryListByChatroomIds(null, chatroomIdSet);
            chatRoomMap = chatRoomList.stream().collect(Collectors.groupingBy(WechatChatRoom::getName));
            robotToRoomMap = chatRoomList.stream().collect(Collectors.groupingBy(WechatChatRoom::getWechatId));
        }
        Map<String, WechatAccount> wechatAccountMap = Collections.emptyMap();
        Map<String, Map<String, List<WechatContact>>> contactMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(wechatIdSet)) {
            List wechatAccountList = this.wechatAccountMapper.queryByWechatIds(wechatIdSet);
            wechatAccountMap = wechatAccountList.stream().collect(Collectors.toMap(it -> it.getWechatId(), Function.identity()));
            List contactList = this.wechatContactMapper.queryListByWechatIdUsernames(wechatIdSet, contactIdSet);
            contactMap = contactList.stream().collect(Collectors.groupingBy(WechatContact::getWechatId, Collectors.groupingBy(WechatContact::getUsername)));
            Map wechatIconMap = this.wechatIconMapper.queryIconByWechatIds(wechatIdSet);
            iconMap.putAll(wechatIconMap);
        }
        for (AutoReplyMessageDto dto : list) {
            AutoReplyMessageType type = AutoReplyMessageType.getType((Integer)dto.getType());
            if (type == null) {
                log.warn("Unknown msg type, msg={}", (Object)dto);
                type = AutoReplyMessageType.TEXT;
            }
            switch (type) {
                case MATERIAL: {
                    MaterialDto material = (MaterialDto)materialDtoMap.get(dto.getMaterialId());
                    this.fill(dto, material);
                    break;
                }
                case DRAINAGE: {
                    DrainagePlan drainagePlan = (DrainagePlan)drainageMap.get(dto.getDrainageId());
                    this.fill(dto, drainagePlan);
                    break;
                }
                case FISSION: {
                    FissionPlan fissionPlan = (FissionPlan)fissionMap.get(dto.getFissionId());
                    this.fill(dto, fissionPlan);
                    break;
                }
                case OFFICIAL_NEWS: {
                    OfficialNewsMaterialDto news = (OfficialNewsMaterialDto)newsDtoMap.get(dto.getOfficialNewsId());
                    this.fill(dto, news);
                    break;
                }
                case OFFICIAL_ACTI: {
                    OfficialActi acti = (OfficialActi)offcialActiMap.get(dto.getOfficialActiId());
                    this.fill(dto, acti);
                    break;
                }
                case JOIN_GROUP_CARD: {
                    this.fill(dto, chatRoomMap, iconMap);
                    this.fill(dto, wechatAccountMap, robotToRoomMap, iconMap);
                    break;
                }
                case CONTACT_BCARD: {
                    this.fillBcard(dto, wechatAccountMap, contactMap, iconMap);
                }
                case MINI_PROGRAM: {
                    SmallRoutine miniProgram = (SmallRoutine)miniProgramMap.get(dto.getMiniProgramId());
                    this.fill(dto, miniProgram);
                    break;
                }
            }
        }
        return list;
    }

    private void fill(AutoReplyMessageDto dto, MaterialDto material) {
        if (material != null) {
            dto.setMType(material.getType());
            dto.setTitle(material.getTitle());
            dto.setMessage(material.getContent());
            dto.setDuration(material.getDuration());
        } else {
            log.warn("No material found with id={}", (Object)dto.getMaterialId());
        }
    }

    private void fill(AutoReplyMessageDto dto, DrainagePlan drainagePlan) {
        if (drainagePlan != null) {
            dto.setTitle(drainagePlan.getName());
            String content = this.drainagePlanService.queryDrainageContentById(dto.getDrainageId());
            dto.setMessage(content);
        } else {
            log.warn("No drainage plan found with id={}", (Object)dto.getDrainageId());
        }
    }

    private void fill(AutoReplyMessageDto dto, FissionPlan fissionPlan) {
        if (fissionPlan != null) {
            dto.setTitle(fissionPlan.getName());
            String content = this.fissionPlanService.queryFissionContentById(dto.getFissionId());
            dto.setMessage(content);
        } else {
            log.warn("No fission plan found with id={}", (Object)dto.getFissionId());
        }
    }

    private void fill(AutoReplyMessageDto dto, SmallRoutine miniProgram) {
        if (miniProgram != null) {
            dto.setAppId(miniProgram.getAppId());
            dto.setUsername(miniProgram.getUserName());
            dto.setNickname(miniProgram.getNickName());
            dto.setTitle(miniProgram.getTitle());
            dto.setDesc(miniProgram.getDescription());
            dto.setThumbUrl(miniProgram.getThumbIconUrl());
            dto.setIconUrl(miniProgram.getIconUrl());
            dto.setUrl(miniProgram.getUrl());
            dto.setPagepath(miniProgram.getPagePath());
        } else {
            log.warn("No miniProgram found with id={}", (Object)dto.getMiniProgramId());
        }
    }

    private void fill(AutoReplyMessageDto dto, OfficialNewsMaterialDto news) {
        if (news != null) {
            dto.setTitle(news.getTitle());
            dto.setDesc(news.getDigest());
            dto.setUrl(news.getUrl());
            dto.setThumbUrl(news.getCover());
        } else {
            log.warn("No official news found with id={}", (Object)dto.getOfficialNewsId());
        }
    }

    private void fill(AutoReplyMessageDto dto, OfficialActi acti) {
        if (acti != null) {
            dto.setTitle(acti.getName());
            String json = acti.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            String message = jsonObject.getString("autoResp");
            String picUrl = acti.getCover();
            dto.setMessage(message);
            dto.setUrl(picUrl);
        } else {
            log.warn("No official acti found with id={}", (Object)dto.getOfficialActiId());
        }
    }

    @Deprecated
    private void fill(AutoReplyMessageDto dto, Map<String, List<WechatChatRoom>> roomMap, Map<String, String> iconMap) {
        if (CollectionUtils.isEmpty((Collection)dto.getChatroomIds())) {
            return;
        }
        List chatroomIds = dto.getChatroomIds();
        ArrayList chatroomList = Lists.newArrayListWithCapacity((int)chatroomIds.size());
        for (String roomId : chatroomIds) {
            WechatChatRoom room;
            String nickName = "";
            String iconUrl = "";
            Integer memberCount = 0;
            Boolean isDeleted = true;
            List<WechatChatRoom> roomList = roomMap.get(roomId);
            if (roomList != null) {
                room = roomList.get(0);
                nickName = this.getChatRoomDisplayName(room.getNickName(), room.getDisplayName());
                memberCount = room.getMemberCount();
                iconUrl = iconMap.get(roomId);
                if (iconUrl == null) {
                    log.warn("Chatroom icon not found. roomId={}", (Object)roomId);
                }
                isDeleted = false;
            } else {
                log.warn("Chatroom not found. roomId={}", (Object)roomId);
            }
            room = new ChatroomRespDto();
            room.setId(roomId);
            room.setNickName(nickName);
            room.setIconUrl(iconUrl);
            room.setMemberCount(memberCount);
            room.setIsDeleted(isDeleted);
            chatroomList.add(room);
        }
        dto.setChatroomList((List)chatroomList);
    }

    private void fill(AutoReplyMessageDto dto, Map<String, WechatAccount> wechatAccountMap, Map<String, List<WechatChatRoom>> robotToRoomMap, Map<String, String> iconMap) {
        List list = dto.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("list is empty with JoinGroupCard, dto={}", (Object)dto);
            return;
        }
        for (RobotToRoomDto invite : list) {
            String wechatId = invite.getWechatId();
            WechatAccount account = wechatAccountMap.get(wechatId);
            if (account != null) {
                invite.setAlias(account.getAlias());
                invite.setNickName(account.getNickName());
            }
            List chatroomIds = invite.getChatroomIds();
            ArrayList chatroomList = Lists.newArrayListWithCapacity((int)chatroomIds.size());
            List<WechatChatRoom> chatRoomList = robotToRoomMap.get(wechatId);
            for (String roomId : chatroomIds) {
                WechatChatRoom room;
                String nickName = "";
                String iconUrl = "";
                Integer memberCount = 0;
                Boolean isDeleted = true;
                if (CollectionUtils.isEmpty(chatRoomList)) {
                    ChatroomRespDto room2 = new ChatroomRespDto();
                    room2.setId(roomId);
                    room2.setNickName(nickName);
                    room2.setIconUrl(iconUrl);
                    room2.setMemberCount(memberCount);
                    room2.setIsDeleted(isDeleted);
                    chatroomList.add(room2);
                    continue;
                }
                Map<String, List<WechatChatRoom>> chatRoomMap = chatRoomList.stream().collect(Collectors.groupingBy(WechatChatRoom::getName));
                List<WechatChatRoom> roomList = chatRoomMap.get(roomId);
                if (roomList != null) {
                    room = roomList.get(0);
                    nickName = this.getChatRoomDisplayName(room.getNickName(), room.getDisplayName());
                    memberCount = room.getMemberCount();
                    iconUrl = iconMap.get(roomId);
                    if (iconUrl == null) {
                        log.warn("Chatroom icon not found. roomId={}", (Object)roomId);
                    }
                    isDeleted = false;
                } else {
                    log.warn("Chatroom not found. roomId={}", (Object)roomId);
                }
                room = new ChatroomRespDto();
                room.setId(roomId);
                room.setNickName(nickName);
                room.setIconUrl(iconUrl);
                room.setMemberCount(memberCount);
                room.setIsDeleted(isDeleted);
                chatroomList.add(room);
            }
            invite.setChatroomList((List)chatroomList);
        }
    }

    private void fillBcard(AutoReplyMessageDto dto, Map<String, WechatAccount> accountMap, Map<String, Map<String, List<WechatContact>>> contactMap, Map<String, String> iconMap) {
        List list = dto.getCards();
        for (BcardDto it : list) {
            String robotId = it.getRobotId();
            String wechatId = it.getWechatId();
            if (StringUtils.isBlank((CharSequence)robotId)) {
                log.warn("bcard robotId is empty, card={}", (Object)it);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)wechatId)) {
                log.warn("bcard wechatId is empty, dto={}", (Object)dto);
                continue;
            }
            if (robotId.equals(wechatId)) {
                WechatAccount account = accountMap.get(wechatId);
                if (account == null) {
                    log.warn("No wechatAccount found with wechatId={}", (Object)wechatId);
                    continue;
                }
                it.setNickname(account.getNickName());
                it.setAlias(account.getAlias());
                it.setAvatar(iconMap.get(wechatId));
                continue;
            }
            Map<String, List<WechatContact>> map = contactMap.get(robotId);
            if (map == null) {
                log.warn("No contact found with robotId={}", (Object)robotId);
                continue;
            }
            List<WechatContact> contactList = map.get(wechatId);
            if (contactList == null || contactList.size() == 0) {
                log.warn("No contact found with username={}", (Object)wechatId);
                continue;
            }
            WechatContact contact = contactList.get(0);
            it.setNickname(contact.getNickname());
            it.setAlias(contact.getAlias());
            it.setAvatar(iconMap.get(wechatId));
        }
    }

    public static long parseLong(String content) {
        long val = -1L;
        try {
            val = Long.parseLong(content);
        }
        catch (NumberFormatException e) {
            log.error("\u89e3\u6790\u6574\u6570\u5931\u8d25: {}", (Object)content, (Object)e);
        }
        return val;
    }
}

