/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.label.dto.WechatLabelListReqDto;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabel;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabelCriteria;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabelWord;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabelWordCriteria;
import com.kuaike.skynet.logic.dal.label.mapper.LogicAutoWechatLabelMapper;
import com.kuaike.skynet.logic.dal.label.mapper.LogicAutoWechatLabelWordMapper;
import com.kuaike.skynet.logic.dal.user.entity.User;
import com.kuaike.skynet.logic.dal.user.mapper.UserMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccount;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoomGroup;
import com.kuaike.skynet.logic.dal.wechat.mapper.MarketingTrafficLevelMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatIconMapper;
import com.kuaike.skynet.logic.service.cache.FriendKeywordTagLabelCacheService;
import com.kuaike.skynet.logic.service.common.WechatCommonService;
import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.reply.FriendKeywordTagLabelService;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelCheckReq;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelDetailResp;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelListReq;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelListResp;
import com.kuaike.skynet.logic.service.reply.dto.label.FriendKeywordLabelReq;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FriendKeywordTagLabelServiceImpl
implements FriendKeywordTagLabelService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordTagLabelServiceImpl.class);
    @Autowired
    private LogicAutoWechatLabelMapper logicAutoWechatLabelMapper;
    @Autowired
    private LogicAutoWechatLabelWordMapper logicAutoWechatLabelWordMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MarketingTrafficLevelMapper marketingTrafficLevelMapper;
    @Autowired
    private WechatChatRoomGroupMapper wechatChatRoomGroupMapper;
    @Autowired
    private FriendKeywordTagLabelCacheService friendKeywordTagLabelCacheService;
    @Autowired
    private WechatIconMapper wechatIconMapper;
    @Autowired
    private WechatCommonService wechatCommonService;
    private static final int accurateKeyword = 1;
    private static final int fuzzyKeyword = 2;
    private static final WechatChatRoomGroup emptyGroup = new WechatChatRoomGroup();
    private static final User emptyUser = new User();
    private static final WechatAccount emptyAccount = new WechatAccount();

    @Transactional(rollbackFor={Exception.class})
    public void add(FriendKeywordLabelReq params) {
        log.info("add friend keyword reply with params={}", (Object)JSON.toJSONString((Object)params));
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        params.validate();
        ArrayList labels = Lists.newArrayListWithCapacity((int)params.getWechatIds().size());
        for (String wechatId : params.getWechatIds()) {
            LogicAutoWechatLabel label = new LogicAutoWechatLabel();
            label.setLabelIds(JSONArray.toJSONString((Object)params.getLabelItemDtoList()));
            label.setRtypesStr(KeywordUtil.idsToStr((List)params.getRtypes()));
            label.setWechatId(wechatId);
            label.setCreateBy(params.getOperatorId());
            label.setUpdateBy(params.getOperatorId());
            label.setNodeId(params.getNodeId());
            label.setMerchantId(params.getBusinessCustomerId());
            labels.add(label);
        }
        this.logicAutoWechatLabelMapper.batchInsert((List)labels);
        this.deletedOldKeyWord(params.getBusinessCustomerId(), params.getOperatorId(), params.getWechatIds());
        ArrayList words = Lists.newArrayList();
        for (LogicAutoWechatLabel label : labels) {
            this.buildWords(params, words, label);
        }
        this.insertWords(words);
        this.friendKeywordTagLabelCacheService.newVersion();
    }

    private void deletedOldKeyWord(Long bizId, Long updatedBy, List<String> wechatIds) {
        List<LogicAutoWechatLabelWord> oldWords = this.selectWordByLabelIds(bizId, wechatIds);
        if (CollectionUtils.isNotEmpty(oldWords)) {
            List ids = oldWords.stream().map(LogicAutoWechatLabelWord::getId).collect(Collectors.toList());
            Integer count = this.logicAutoWechatLabelWordMapper.deletedByIds(ids, updatedBy);
            log.info("update count:{}", (Object)count);
        }
    }

    private void insertWords(List<LogicAutoWechatLabelWord> words) {
        if (CollectionUtils.isNotEmpty(words)) {
            this.logicAutoWechatLabelWordMapper.batchInsert(words.stream().sorted(Comparator.comparing(LogicAutoWechatLabelWord::getKeyWord)).collect(Collectors.toList()));
        }
    }

    private LogicAutoWechatLabelWord buildWechatLabelWord(String keyword, int type, String wechatId, FriendKeywordLabelReq params) {
        LogicAutoWechatLabelWord word = new LogicAutoWechatLabelWord();
        word.setWechatId(wechatId);
        word.setKeyWord(keyword);
        word.setType(Integer.valueOf(type));
        word.setCreateBy(params.getOperatorId());
        word.setUpdateBy(params.getOperatorId());
        word.setNodeId(params.getNodeId());
        word.setMerchantId(params.getBusinessCustomerId());
        return word;
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(FriendKeywordLabelReq params) {
        log.info("modify params:{}", (Object)JSON.toJSONString((Object)params));
        params.validate();
        Preconditions.checkArgument((boolean)Objects.nonNull(params.getId()), (Object)"id not null");
        LogicAutoWechatLabel selectLabel = (LogicAutoWechatLabel)this.logicAutoWechatLabelMapper.selectByPrimaryKey((Object)params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(selectLabel), (String)"\u4fee\u6539\u7684\u914d\u7f6e\u4e0d\u5b58\u5728id:{}", (Object)params.getId());
        LogicAutoWechatLabel label = new LogicAutoWechatLabel();
        label.setLabelIds(JSONArray.toJSONString((Object)params.getLabelItemDtoList()));
        label.setRtypesStr(KeywordUtil.idsToStr((List)params.getRtypes()));
        label.setId(params.getId());
        label.setUpdateBy(params.getOperatorId());
        label.setUpdateTime(new Date());
        label.setNodeId(params.getNodeId());
        this.logicAutoWechatLabelMapper.updateByPrimaryKeySelective((Object)label);
        this.deletedOldKeyWord(params.getBusinessCustomerId(), params.getOperatorId(), Lists.newArrayList((Object[])new String[]{selectLabel.getWechatId()}));
        ArrayList newWords = Lists.newArrayList();
        this.buildWords(params, newWords, selectLabel);
        this.insertWords(newWords);
        this.friendKeywordTagLabelCacheService.newVersion();
    }

    private void buildWords(FriendKeywordLabelReq params, List<LogicAutoWechatLabelWord> newWords, LogicAutoWechatLabel selectLabel) {
        if (StringUtils.isNotBlank((CharSequence)params.getAccurateKeyword())) {
            newWords.add(this.buildWechatLabelWord(params.getAccurateKeyword(), 1, selectLabel.getWechatId(), params));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getFuzzyKeyword())) {
            newWords.add(this.buildWechatLabelWord(params.getFuzzyKeyword(), 2, selectLabel.getWechatId(), params));
        }
    }

    public FriendKeywordLabelListResp list(FriendKeywordLabelListReq params) {
        Integer count;
        log.info("list req:{}", (Object)JSON.toJSONString((Object)params));
        FriendKeywordLabelListResp friendKeywordLabelListResp = new FriendKeywordLabelListResp();
        WechatLabelListReqDto req = (WechatLabelListReqDto)BeanUtil.convert((Object)params, WechatLabelListReqDto.class, (String[])new String[0]);
        friendKeywordLabelListResp.setPageDto(req.getPageDto());
        if (StringUtils.isNotBlank((CharSequence)params.getKeywordQuery())) {
            Set wechatIds = this.logicAutoWechatLabelWordMapper.fuzzyQueryWechatLabelIds(params.getKeywordQuery(), params.getBusinessCustomerId());
            req.setWechatIds(wechatIds);
            if (CollectionUtils.isEmpty((Collection)wechatIds)) {
                friendKeywordLabelListResp.setList(Collections.emptyList());
                params.getPageDto().setCount(Integer.valueOf(0));
                return friendKeywordLabelListResp;
            }
        }
        if (Objects.isNull(count = this.logicAutoWechatLabelMapper.selectWechatLabelCount(req)) || count == 0) {
            friendKeywordLabelListResp.setList(Collections.emptyList());
            params.getPageDto().setCount(Integer.valueOf(0));
            return friendKeywordLabelListResp;
        }
        req.setCount(count);
        List list = this.logicAutoWechatLabelMapper.selectWechatLabelList(req);
        friendKeywordLabelListResp.setList(this.toRespList(count, list, params.getBusinessCustomerId()));
        friendKeywordLabelListResp.setPageDto(req.getPageDto());
        return friendKeywordLabelListResp;
    }

    private List<LogicAutoWechatLabelWord> selectWordByLabelIds(Long merchantId, List<String> wechatIds) {
        LogicAutoWechatLabelWordCriteria criteria = new LogicAutoWechatLabelWordCriteria();
        criteria.createCriteria().andWechatIdIn(wechatIds).andMerchantIdEqualTo(merchantId).andIsDeletedEqualTo(Integer.valueOf(0));
        return this.logicAutoWechatLabelWordMapper.selectByExample((Object)criteria);
    }

    private List<FriendKeywordLabelDetailResp> toRespList(Integer count, List<LogicAutoWechatLabel> list, Long merchantId) {
        ArrayList respList = Lists.newArrayListWithExpectedSize((int)count);
        List<String> wechatIds = list.stream().map(LogicAutoWechatLabel::getWechatId).collect(Collectors.toList());
        Map<String, Map<Integer, List<LogicAutoWechatLabelWord>>> keywordIdMap = this.selectWordByLabelIds(merchantId, wechatIds).stream().collect(Collectors.groupingBy(LogicAutoWechatLabelWord::getWechatId, Collectors.groupingBy(LogicAutoWechatLabelWord::getType)));
        Map wechatAccountMap = this.wechatAccountMapper.queryByWechatIds(wechatIds).stream().collect(Collectors.toMap(WechatAccount::getWechatId, Function.identity(), (u, v) -> v));
        List userIds = list.stream().map(LogicAutoWechatLabel::getUpdateBy).collect(Collectors.toList());
        Map userMap = this.userMapper.selectByIds(userIds).stream().collect(Collectors.toMap(User::getId, Function.identity(), (u, v) -> v));
        List labelItemDtoList = list.stream().flatMap(t -> JSONArray.parseArray((String)t.getLabelIds(), LabelItemDto.class).stream()).collect(Collectors.toList());
        Set labelIds = labelItemDtoList.stream().map(LabelItemDto::getLabelId).collect(Collectors.toSet());
        Map labelMap = this.wechatChatRoomGroupMapper.queryChatRoomGroupByIds(merchantId, labelIds).stream().collect(Collectors.toMap(WechatChatRoomGroup::getId, Function.identity(), (u, v) -> v));
        Map flowLevelMap = this.marketingTrafficLevelMapper.queryTrafficLevelMap(merchantId);
        Map iconMap = this.wechatIconMapper.queryIconByWechatIds(wechatIds);
        Map onlineMap = this.wechatCommonService.queryWechatStatus(wechatIds);
        for (LogicAutoWechatLabel label : list) {
            FriendKeywordLabelDetailResp detail = new FriendKeywordLabelDetailResp();
            detail.setId(label.getId());
            List labelItemDtos = JSONArray.parseArray((String)label.getLabelIds(), LabelItemDto.class);
            for (LabelItemDto itemDto : labelItemDtos) {
                itemDto.setLabelName(labelMap.getOrDefault(itemDto.getLabelId(), emptyGroup).getName());
                itemDto.setFlowLevel((Integer)flowLevelMap.get(itemDto.getFlowLevelId()));
            }
            detail.setLabelItemDtoList(labelItemDtos);
            OperatorResp operatorResp = new OperatorResp();
            operatorResp.setId(label.getId());
            operatorResp.setNickname(userMap.getOrDefault(label.getUpdateBy(), emptyUser).getNickName());
            operatorResp.setOperateTime(label.getUpdateTime());
            operatorResp.setUsername(userMap.getOrDefault(label.getUpdateBy(), emptyUser).getName());
            detail.setUpdator(operatorResp);
            WechatResp wechatResp = new WechatResp();
            wechatResp.setAvatar((String)iconMap.get(label.getWechatId()));
            wechatResp.setIsOnline((Boolean)onlineMap.get(label.getWechatId()));
            wechatResp.setId(label.getWechatId());
            wechatResp.setNickname(wechatAccountMap.getOrDefault(label.getWechatId(), emptyAccount).getNickName());
            wechatResp.setAlias(wechatAccountMap.getOrDefault(label.getWechatId(), emptyAccount).getAlias());
            detail.setWechatDetail(wechatResp);
            Map wordMap = keywordIdMap.getOrDefault(label.getWechatId(), Collections.emptyMap());
            List words = (List)wordMap.get(1);
            if (CollectionUtils.isNotEmpty((Collection)words)) {
                detail.setAccurateKeyword(((LogicAutoWechatLabelWord)words.get(0)).getKeyWord());
            }
            if (CollectionUtils.isNotEmpty((Collection)(words = (List)wordMap.get(2)))) {
                detail.setFuzzyKeyword(((LogicAutoWechatLabelWord)words.get(0)).getKeyWord());
            }
            detail.setRtypes(Splitter.on((String)",").splitToList((CharSequence)label.getRtypesStr()).stream().map(Integer::valueOf).collect(Collectors.toList()));
            respList.add(detail);
        }
        return respList;
    }

    public FriendKeywordLabelDetailResp detail(FriendKeywordLabelIdReqDto params) {
        log.info("detail params:{}", (Object)JSON.toJSONString((Object)params));
        WechatLabelListReqDto req = (WechatLabelListReqDto)BeanUtil.convert((Object)params, WechatLabelListReqDto.class, (String[])new String[0]);
        req.setIds((Set)Sets.newHashSet((Object[])new Long[]{params.getId()}));
        List list = this.logicAutoWechatLabelMapper.selectWechatLabelList(req);
        List<FriendKeywordLabelDetailResp> respList = this.toRespList(1, list, params.getBusinessCustomerId());
        if (CollectionUtils.isNotEmpty(respList)) {
            return respList.get(0);
        }
        return new FriendKeywordLabelDetailResp();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(FriendKeywordLabelIdReqDto params) {
        log.info("delete params:{}", (Object)JSON.toJSONString((Object)params));
        Preconditions.checkArgument((boolean)Objects.nonNull(params.getId()), (Object)"id not null");
        Preconditions.checkArgument((boolean)Objects.nonNull(params.getOperatorId()), (Object)"OperatorId not null");
        LogicAutoWechatLabel selectLabel = (LogicAutoWechatLabel)this.logicAutoWechatLabelMapper.selectByPrimaryKey((Object)params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(selectLabel), (String)"\u4fee\u6539\u7684\u914d\u7f6e\u4e0d\u5b58\u5728id:{}", (Object)params.getId());
        int count = this.logicAutoWechatLabelMapper.deletedWechatLabel(params.getId(), params.getOperatorId());
        int count2 = this.logicAutoWechatLabelWordMapper.deletedByWechatId(selectLabel.getWechatId(), params.getOperatorId(), params.getBusinessCustomerId());
        log.info("delete seccess count:{}, count2:{}", (Object)count, (Object)count2);
        this.friendKeywordTagLabelCacheService.newVersion();
    }

    public Set<WechatResp> check(FriendKeywordLabelCheckReq req) {
        log.info("check params:{}", (Object)JSON.toJSONString((Object)req));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)req.getWechatIds()), (Object)"wechatIds not empty");
        List<LogicAutoWechatLabel> labels = this.selectWechatLabelByWechatIds(req.getWechatIds(), req.getBusinessCustomerId());
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptySet();
        }
        List wechatIds = labels.stream().map(LogicAutoWechatLabel::getWechatId).collect(Collectors.toList());
        Map wechatAccountMap = this.wechatAccountMapper.queryByWechatIds(wechatIds).stream().collect(Collectors.toMap(WechatAccount::getWechatId, Function.identity(), (u, v) -> v));
        HashSet result = Sets.newHashSetWithExpectedSize((int)wechatIds.size());
        for (String wechatId : wechatIds) {
            WechatResp wechatResp = new WechatResp();
            wechatResp.setId(wechatId);
            wechatResp.setNickname(wechatAccountMap.getOrDefault(wechatId, emptyAccount).getNickName());
            wechatResp.setAlias(wechatAccountMap.getOrDefault(wechatId, emptyAccount).getAlias());
            result.add(wechatResp);
        }
        return result;
    }

    private List<LogicAutoWechatLabel> selectWechatLabelByWechatIds(Set<String> wechatIds, Long businessCustomerId) {
        LogicAutoWechatLabelCriteria criteria = new LogicAutoWechatLabelCriteria();
        criteria.createCriteria().andWechatIdIn((List)Lists.newArrayList(wechatIds)).andIsDeletedEqualTo(Integer.valueOf(0)).andMerchantIdEqualTo(businessCustomerId);
        return this.logicAutoWechatLabelMapper.selectByExample((Object)criteria);
    }
}

