/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.service.cache.ReplyOptionCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedOption;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ReplyOptionCacheServiceImpl
implements ReplyOptionCacheService {
    private static final Logger log = LoggerFactory.getLogger(ReplyOptionCacheServiceImpl.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.key.replyOption.format:reply_option:%s:%s}")
    private String replyOptionKeyFormat;
    @Value(value="${spring.redis.key.replyOption.expire:600}")
    private Long replyOptionExpireTime;

    @Override
    public String buildOptions(String title, List<CachedReplyMsg> matched) {
        int size = matched.size();
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append("\n");
        for (int i = 0; i < size; ++i) {
            CachedReplyMsg msg = matched.get(i);
            sb.append(i + 1);
            sb.append(". ");
            sb.append(msg.getDesc());
            if (i >= size - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public CachedReplyMsg getValidOption(CachedOption cache, String text) {
        if (cache == null) {
            return null;
        }
        int max = cache.getOptions().size();
        int index = -1;
        try {
            index = Integer.parseInt(text, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (index < 1 || index > max) {
            return null;
        }
        return cache.getOptions().get(index - 1);
    }

    @Override
    public String getReplyOptionKey(Long buId, String from, String to) {
        return this.redisKeyPrefix + String.format(this.replyOptionKeyFormat, buId + ":" + from, to);
    }

    @Override
    public void clearCache(Long buId, String from, String to) {
        String redisKey = this.getReplyOptionKey(buId, from, to);
        try {
            this.redisTemplate.delete((Object)redisKey);
            log.info("Clear cache reply options with key:{}", (Object)redisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Clear cache reply options failed", (Throwable)e);
        }
    }

    @Override
    public void cache(String redisKey, String wechatId, Long buId, String text, List<CachedReplyMsg> matched) {
        int size = matched.size();
        ArrayList options = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            CachedReplyMsg msg = matched.get(i);
            options.add(msg);
        }
        CachedOption cache = new CachedOption();
        cache.setText(text);
        cache.setOptions(options);
        cache.setWId(wechatId);
        String json = JacksonUtil.obj2Str((Object)cache);
        try {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)json, this.getExpireTime().longValue(), TimeUnit.SECONDS);
            log.info("Cache reply options with key:{}, json={}", (Object)redisKey, (Object)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Cache reply options failed", (Throwable)e);
        }
    }

    private Long getExpireTime() {
        return this.replyOptionExpireTime;
    }

    @Override
    public CachedOption getCachedOption(String redisKey) {
        CachedOption result = null;
        try {
            String json = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                result = (CachedOption)JacksonUtil.str2Obj((String)json, CachedOption.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Cache reply options failed", (Throwable)e);
        }
        return result;
    }
}

