/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.service.cache.FriendKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyData;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.cache.impl.AbstractMerchantKeywordCache;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class FriendKeywordCacheServiceImpl
extends AbstractMerchantKeywordCache<String>
implements FriendKeywordCacheService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordCacheServiceImpl.class);
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.friendReplyVersion:friend_reply_version}")
    private String versionRedisKey;

    @Override
    public void newVersion() {
        super.reset();
    }

    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    protected Long getExpiredInSecond() {
        return 300L;
    }

    protected void initialize() {
        ConcurrentMap merchantDataMap = Maps.newConcurrentMap();
        LogicAutoReply example = new LogicAutoReply();
        example.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        example.setRelationType(Integer.valueOf(AutoReplyRelationType.WECHAT.getValue()));
        example.setEnabled(Integer.valueOf(1));
        example.setIsDeleted(Integer.valueOf(0));
        List replyList = this.logicAutoReplyMapper.select((Object)example);
        List ids = replyList.stream().map(it -> it.getId()).collect(Collectors.toList());
        List wordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(ids);
        Map<Long, List<LogicAutoReplyWord>> wordMap = wordList.stream().collect(Collectors.groupingBy(LogicAutoReplyWord::getAutoReplyId));
        List wechatList = this.logicAutoReplyWechatMapper.selectByAutoReplyIds(ids);
        Map<Long, List<LogicAutoReplyWechat>> wechatMap = wechatList.stream().collect(Collectors.groupingBy(LogicAutoReplyWechat::getAutoReplyId));
        ArrayList uselessIds = Lists.newArrayList();
        for (LogicAutoReply it2 : replyList) {
            List<LogicAutoReplyWord> replyWordList;
            Long id = it2.getId();
            Long businessCustomerId = it2.getMerchantId();
            Map cachedReplyData = (Map)merchantDataMap.get(businessCustomerId);
            if (cachedReplyData == null) {
                cachedReplyData = Maps.newHashMap();
                merchantDataMap.put(businessCustomerId, cachedReplyData);
            }
            if (CollectionUtils.isEmpty(replyWordList = wordMap.get(id))) {
                uselessIds.add(id);
                continue;
            }
            List<LogicAutoReplyWechat> replyWechat = wechatMap.get(id);
            if (CollectionUtils.isEmpty(replyWechat)) {
                uselessIds.add(id);
                continue;
            }
            HashMap accurateMatch = Maps.newHashMap();
            HashSet dict = Sets.newHashSet();
            HashMap wordToReplyIds = Maps.newHashMap();
            HashMap<String, CachedReplyMsg> idToReplyMap = new HashMap<String, CachedReplyMsg>();
            CachedReplyMsg reply = new CachedReplyMsg();
            reply.setReplyId(id);
            reply.setDesc(it2.getRequest());
            reply.setMsg(it2.getMessage());
            reply.setUpdateTime(it2.getUpdateTime().getTime());
            if (StringUtils.isNotBlank((CharSequence)it2.getDigest())) {
                reply.setDigest(it2.getDigest());
            } else {
                reply.setDigest(SHA1Utils.digest((String)it2.getMessage()));
            }
            idToReplyMap.put(reply.getId(), reply);
            for (LogicAutoReplyWord replyWord : replyWordList) {
                String[] words;
                String keyword = replyWord.getKeyWord();
                Integer type = replyWord.getType();
                if (type.intValue() == KeywordMatchType.ACCURATE.getValue()) {
                    accurateMatch.put(keyword, reply.getId());
                    continue;
                }
                for (String w : words = StringUtils.split((String)keyword, (String)",")) {
                    dict.add(w);
                    ArrayList<String> list = (ArrayList<String>)wordToReplyIds.get(w);
                    if (list == null) {
                        list = new ArrayList<String>();
                        wordToReplyIds.put(w, list);
                    }
                    list.add(reply.getId());
                }
            }
            for (LogicAutoReplyWechat wechat : replyWechat) {
                String wechatId = wechat.getWechatId();
                CachedReplyData cache = (CachedReplyData)cachedReplyData.get(wechatId);
                if (cache == null) {
                    cache = new CachedReplyData();
                    cachedReplyData.put(wechatId, cache);
                }
                cache.merge(accurateMatch, dict, wordToReplyIds, idToReplyMap);
            }
        }
        this.cachedReplyData = merchantDataMap;
        if (CollectionUtils.isNotEmpty((Collection)uselessIds)) {
            log.warn("Useless reply ids={}", (Object)uselessIds);
        }
    }
}

