/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.dto;

import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class WordHit {
    private String word;
    private List<CachedReplyMsg> list;
    private Set<LabelItemDto> labelItemDtoSet;
    private static final Comparator<CachedReplyMsg> ORDER_BY_UPDATE_TIME_DESC = new Comparator<CachedReplyMsg>(){

        @Override
        public int compare(CachedReplyMsg o1, CachedReplyMsg o2) {
            if (o1.getUpdateTime() == null && o2.getUpdateTime() == null) {
                return 0;
            }
            if (o2.getUpdateTime() == null) {
                return -1;
            }
            if (o1.getUpdateTime() == null) {
                return 1;
            }
            return o2.getUpdateTime().compareTo(o1.getUpdateTime());
        }
    };

    public WordHit(String word, Set<LabelItemDto> set) {
        this.word = word;
        this.labelItemDtoSet = set;
    }

    public WordHit(String word, List<CachedReplyMsg> list) {
        this.word = word;
        this.list = list;
        if (list != null && list.size() > 1) {
            list.sort(ORDER_BY_UPDATE_TIME_DESC);
        }
    }

    public CachedReplyMsg first() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.get(0);
        }
        return null;
    }

    public String getWord() {
        return this.word;
    }

    public List<CachedReplyMsg> getList() {
        return this.list;
    }

    public Set<LabelItemDto> getLabelItemDtoSet() {
        return this.labelItemDtoSet;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void setList(List<CachedReplyMsg> list) {
        this.list = list;
    }

    public void setLabelItemDtoSet(Set<LabelItemDto> labelItemDtoSet) {
        this.labelItemDtoSet = labelItemDtoSet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordHit)) {
            return false;
        }
        WordHit other = (WordHit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$word = this.getWord();
        String other$word = other.getWord();
        if (this$word == null ? other$word != null : !this$word.equals(other$word)) {
            return false;
        }
        List<CachedReplyMsg> this$list = this.getList();
        List<CachedReplyMsg> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Set<LabelItemDto> this$labelItemDtoSet = this.getLabelItemDtoSet();
        Set<LabelItemDto> other$labelItemDtoSet = other.getLabelItemDtoSet();
        return !(this$labelItemDtoSet == null ? other$labelItemDtoSet != null : !((Object)this$labelItemDtoSet).equals(other$labelItemDtoSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordHit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $word = this.getWord();
        result = result * 59 + ($word == null ? 43 : $word.hashCode());
        List<CachedReplyMsg> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Set<LabelItemDto> $labelItemDtoSet = this.getLabelItemDtoSet();
        result = result * 59 + ($labelItemDtoSet == null ? 43 : ((Object)$labelItemDtoSet).hashCode());
        return result;
    }

    public String toString() {
        return "WordHit(word=" + this.getWord() + ", list=" + this.getList() + ", labelItemDtoSet=" + this.getLabelItemDtoSet() + ")";
    }
}

