/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.impl;

import com.google.common.collect.Lists;
import com.kuaike.skynet.link.service.PushService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.WechatStatusInfo;
import com.kuaike.skynet.logic.dal.wechat.dto.WechatAccountDto;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import com.kuaike.skynet.logic.service.debug.dto.MemPrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatDebugService
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(WechatDebugService.class);
    private static final String NOTHING_FOUND = "Nothing found";
    private static final int MIN_SIZE = 10;
    private static final int MAX_SIZE = 100;
    private static final int PAGE = 1;
    private static final int SIZE = 30;
    private final Options options = new Options();
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private PushService pushService;

    @Override
    public String getCmd() {
        return "wechat";
    }

    public WechatDebugService() {
        this.options.addOption("h", "help", false, "\u5e2e\u52a9");
        this.options.addOption("p", "page", true, "\u9875\u7801 [1, +)");
        this.options.addOption("s", "size", true, "\u6bcf\u9875\u5927\u5c0f [10, 100]");
        this.options.addOption("a", "all", false, "\u53ea\u663e\u793a\u5728\u7ebf\u7684\u5fae\u4fe1\u53f7");
        this.options.addOption("l", "list", false, "\u5217\u51fa\u6240\u6709\u5fae\u4fe1\u53f7");
        this.options.addOption("q", "query", true, "\u6839\u636e\u6635\u79f0\u67e5\u8be2\u5fae\u4fe1\u53f7");
        this.options.addOption("w", "wechatId", true, "\u6839\u636ewechatId\u67e5\u8be2\u5fae\u4fe1\u53f7");
    }

    @Override
    public DebugResult process(String wechatId, String talkerId, String ... args) {
        String v;
        CommandLine cmd;
        log.info("process wechat cmd with wechatId={}, args={}", (Object)wechatId, (Object)args);
        int page = 1;
        int size = 30;
        boolean listAll = false;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            return DebugResult.error(2, e.getMessage());
        }
        if (cmd.hasOption("h")) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        if (cmd.hasOption("p")) {
            v = cmd.getOptionValue("p");
            try {
                page = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return DebugResult.error(-1, e.getMessage());
            }
            if (page < 1) {
                page = 1;
            }
        }
        if (cmd.hasOption("s")) {
            v = cmd.getOptionValue("s");
            try {
                size = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return DebugResult.error(-1, e.getMessage());
            }
            if (size < 10) {
                size = 10;
            }
            if (size > 100) {
                size = 100;
            }
        }
        if (cmd.hasOption("a")) {
            listAll = true;
        }
        if (cmd.hasOption("w")) {
            v = cmd.getOptionValue("w");
            return this.get(v);
        }
        if (cmd.hasOption("q")) {
            v = cmd.getOptionValue("q");
            return this.query(v, page, size);
        }
        if (cmd.hasOption("l")) {
            return this.list(page, size, listAll);
        }
        return DebugResult.help(this.getCmd(), this.options);
    }

    private Map<String, WechatStatusInfo> queryOnlineStatus(List<WechatAccountDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        List<String> wechatIds = list.stream().map(it -> it.getWechatId()).collect(Collectors.toList());
        List<WechatStatusInfo> statusList = this.queryWechatStatus(wechatIds);
        return statusList.stream().collect(Collectors.toMap(it -> it.getWId(), it -> it));
    }

    private DebugResult render(List<WechatAccountDto> list, int page, int size, boolean listAll) {
        if (CollectionUtils.isEmpty(list)) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        Map<Object, Object> statusMap = Collections.emptyMap();
        if (!listAll) {
            statusMap = this.queryOnlineStatus(list);
            ArrayList online = Lists.newArrayListWithCapacity((int)list.size());
            for (WechatAccountDto ac : list) {
                WechatStatusInfo status = (WechatStatusInfo)statusMap.get(ac.getWechatId());
                if (status == null || !StringUtils.isNotBlank((CharSequence)status.getIp())) continue;
                online.add(ac);
            }
            if (CollectionUtils.isEmpty((Collection)online)) {
                return DebugResult.ok(NOTHING_FOUND);
            }
            list = online;
        }
        int len = list.size();
        int from = size * (page - 1);
        int to = from + size;
        if (from > len - 1) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        if (to > len) {
            to = len;
        }
        int totalPage = len / size;
        if (len % size != 0) {
            ++totalPage;
        }
        list = list.subList(from, to);
        if (listAll) {
            List<String> wechatIds = list.stream().map(it -> it.getWechatId()).collect(Collectors.toList());
            List<WechatStatusInfo> statusList = this.queryWechatStatus(wechatIds);
            statusMap = statusList.stream().collect(Collectors.toMap(it -> it.getWId(), it -> it));
        }
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().println("ID, \u7ed1\u5b9a\u7528\u6237ID, \u7ed1\u5b9a\u5546\u6237ID, \u6635\u79f0, \u5fae\u4fe1\u53f7, \u5728\u7ebf\u72b6\u6001");
        for (WechatAccountDto ac : list) {
            WechatStatusInfo status = (WechatStatusInfo)statusMap.get(ac.getWechatId());
            String ip = status != null && status.getIp() != null ? status.getIp() : "\u79bb\u7ebf";
            out.getPrintWriter().printf("%s, %d, %d, %s, %s, %s\n", ac.getWechatId(), ac.getUserId(), ac.getBusinessCustomerId(), ac.getNickname(), ac.getAlias(), ip);
        }
        out.getPrintWriter().printf("\u9875\u7801 %d/%d \u5f53\u524d\u6570\u91cf:%d", page, totalPage, list.size());
        return DebugResult.ok(out.toString());
    }

    private DebugResult query(String query, int page, int size) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        List<WechatAccountDto> list = this.wechatAccountCacheService.listAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        list = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getNickname()) && it.getNickname().contains(query) || StringUtils.isNotBlank((CharSequence)it.getAlias()) && it.getAlias().contains(query)).collect(Collectors.toList());
        return this.render(list, page, size, true);
    }

    public DebugResult get(String wechatId) {
        WechatAccountDto ac = this.wechatAccountCacheService.getAccount(wechatId);
        if (ac == null) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        return this.render(Collections.singletonList(ac), 1, 1, true);
    }

    public DebugResult list(int page, int size, boolean listAll) {
        List list = this.wechatAccountCacheService.listAll();
        return this.render(list, page, size, listAll);
    }

    public List<WechatStatusInfo> queryWechatStatus(List<String> wechatIds) {
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Collections.emptyList();
        }
        BaseResponse resp = this.pushService.queryWechatsStatus(wechatIds);
        if (resp.getCode() != 0L) {
            log.warn("query wechat status failed. wechatIds={}, resp={}", wechatIds, (Object)resp);
            return Collections.emptyList();
        }
        return (List)resp.getData();
    }
}

