/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.impl;

import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeDebugService
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(TimeDebugService.class);
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final Options options = new Options();

    @Override
    public String getCmd() {
        return "time";
    }

    public TimeDebugService() {
        this.options.addOption("h", "help", false, "\u5e2e\u52a9");
        this.options.addOption("f", "format", true, "\u65f6\u95f4\u683c\u5f0f, \u9ed8\u8ba4yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public DebugResult process(String wechatId, String talkerId, String ... args) {
        CommandLine cmd;
        log.info("query time with wechatId={}, args={}", (Object)wechatId, (Object)Arrays.toString(args));
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            return DebugResult.error(2, e.getMessage());
        }
        if (cmd.hasOption("h")) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        String format = DEFAULT_FORMAT;
        if (cmd.hasOption("f")) {
            format = cmd.getOptionValue("f");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return DebugResult.ok(sdf.format(new Date()));
    }
}

