/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.impl;

import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HostDebugService
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(HostDebugService.class);

    @Override
    public String getCmd() {
        return "host";
    }

    @Override
    public DebugResult process(String wechatId, String talkerId, String ... args) {
        log.info("query host info with wechatId={}, args={}", (Object)Arrays.toString(args));
        StringBuilder sb = new StringBuilder();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            sb.append("host.name:").append(addr.getHostName()).append("\n");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String[] params = new String[]{"os.name", "os.arch", "os.version", "java.vendor", "java.version"};
        for (int i = 0; i < params.length; ++i) {
            String name = params[i];
            String value = System.getProperty(name);
            sb.append(name).append("=").append(value);
            if (i >= params.length - 1) continue;
            sb.append("\n");
        }
        return DebugResult.ok(sb.toString());
    }
}

