/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class OpSession {
    private static final Logger log = LoggerFactory.getLogger(OpSession.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}${debugEntrance.session.key-format:debugEntrance:%s}")
    private String keyFormat;
    @Value(value="${debugEntrance.session.timeout:300}")
    private Long timeout;

    public void set(String wechatId) {
        String redisKey = String.format(this.keyFormat, wechatId);
        try {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)wechatId, Duration.ofSeconds(this.timeout));
        }
        catch (Exception e) {
            log.error("Failed setting session for op={}", (Object)wechatId, (Object)e);
        }
    }

    public boolean exist(String wechatId) {
        String redisKey = String.format(this.keyFormat, wechatId);
        try {
            Object obj = this.redisTemplate.opsForValue().get((Object)redisKey);
            return obj != null;
        }
        catch (Exception e) {
            log.error("Failed get session for op={}", (Object)wechatId, (Object)e);
            return false;
        }
    }

    public void delete(String wechatId) {
        try {
            String redisKey = String.format(this.keyFormat, wechatId);
            this.redisTemplate.delete((Object)redisKey);
        }
        catch (Exception e) {
            log.error("Failed deleting sessionn for op={}", (Object)wechatId, (Object)e);
        }
    }
}

