/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug;

import com.google.common.collect.Maps;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.OpManager;
import com.kuaike.skynet.logic.service.debug.OpSession;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DebugEntrance
implements CommandLineRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DebugEntrance.class);
    @Autowired
    private OpSession opSession;
    @Autowired
    private OpManager opManager;
    @Value(value="${debugEntrance.enabled:false}")
    private boolean isEnabled;
    @Value(value="${debugEntrance.secret:lOgItEcH}")
    private String secret;
    private Map<String, DebugService> beanMap = Maps.newConcurrentMap();

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void run(String ... args) throws Exception {
        if (this.isEnabled) {
            if (StringUtils.isBlank((CharSequence)this.secret)) {
                this.isEnabled = false;
                return;
            }
            log.info("WARNING: DEBUG MODE ENABLED.");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = applicationContext.getBeanNamesForType(DebugService.class)) {
            DebugService bean = (DebugService)applicationContext.getBean(beanName, DebugService.class);
            this.beanMap.put(bean.getCmd(), bean);
        }
        log.info("beanMap={}", this.beanMap);
    }

    private boolean valid(String message, String talkerId) {
        if (!this.isEnabled) {
            return false;
        }
        if (!this.opManager.isOp(talkerId)) {
            return false;
        }
        if (this.opSession.exist(talkerId)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.secret) || !message.startsWith(this.secret)) {
            return false;
        }
        log.info("Op logged in with wechatId={}", (Object)talkerId);
        return true;
    }

    public DebugResult process(WechatMessage wechatMessage) {
        String message = wechatMessage.getMessage();
        String wechatId = wechatMessage.getWechatId();
        String talkerId = null;
        talkerId = wechatMessage.getTalkerType() == 1 ? wechatMessage.getTalkerId() : wechatMessage.getChatroomTalkerId();
        if (!this.valid(message, talkerId)) {
            return DebugResult.invalid();
        }
        this.opSession.set(talkerId);
        if (message.startsWith(this.secret)) {
            message = message.substring(this.secret.length());
        }
        String[] args = StringUtils.split((String)message, (String)" ");
        int len = args.length;
        if (args == null || len == 0) {
            return DebugResult.ok("\u547d\u4ee4: " + StringUtils.join(this.beanMap.keySet(), (String)", "));
        }
        String cmd = args[0];
        DebugService bean = this.beanMap.get(cmd);
        if (bean == null) {
            return DebugResult.ok("\u547d\u4ee4: " + StringUtils.join(this.beanMap.keySet(), (String)", "));
        }
        String[] args2 = new String[len - 1];
        if (len > 1) {
            System.arraycopy(args, 1, args2, 0, len - 1);
        }
        return bean.process(wechatId, talkerId, args2);
    }
}

