/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunOssUtils {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssUtils.class);
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.roleArn}")
    private String roleArn;
    @Value(value="${aliyun.oss.bucket}")
    private String bucket;
    @Value(value="${aliyun.oss.file.expireDays}")
    private long expireDays;
    private static String ENDPOINT_STATIC;
    private static String ACCESSKEYID_STATIC;
    private static String ACCESSKEYSECRET_STATIC;
    private static String ROLEARN_STATIC;
    private static String BUCKET_STATIC;
    private static long EXPIREDAYS_STATIC;

    public static AssumeRoleResponse getSTS() throws ClientException {
        String accessKeyId = ACCESSKEYID_STATIC;
        String accessKeySecret = ACCESSKEYSECRET_STATIC;
        String roleArn = ROLEARN_STATIC;
        String roleSessionName = "session-name";
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)accessKeyId, (String)accessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setProtocol(ProtocolType.HTTPS);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            return response;
        }
        catch (Exception e) {
            log.error("STS Request Failed e{}", (Throwable)e);
            throw e;
        }
    }

    @PostConstruct
    public void init() {
        ENDPOINT_STATIC = this.endpoint;
        ACCESSKEYID_STATIC = this.accessKeyId;
        ACCESSKEYSECRET_STATIC = this.accessKeySecret;
        ROLEARN_STATIC = this.roleArn;
        BUCKET_STATIC = this.bucket;
        EXPIREDAYS_STATIC = this.expireDays;
    }

    public static String uploadFile(File file, String fileKey) {
        String fileDir = "skynet-convert/";
        OSS ossClient = new OSSClientBuilder().build(ENDPOINT_STATIC, ACCESSKEYID_STATIC, ACCESSKEYSECRET_STATIC);
        fileKey = fileDir + fileKey;
        log.info("uploadFile fileKey:{}", (Object)fileKey);
        ossClient.putObject(BUCKET_STATIC, fileKey, file);
        ossClient.shutdown();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://").append(BUCKET_STATIC).append(".").append(ENDPOINT_STATIC).append("/").append(fileKey);
        return urlBuilder.toString();
    }
}

