/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA1Utils {
    private static final Logger log = LoggerFactory.getLogger(SHA1Utils.class);
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String digest(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return "";
        }
        byte[] input = message.getBytes();
        try {
            MessageDigest mDigest = MessageDigest.getInstance("SHA1");
            byte[] digest = mDigest.digest(input);
            return SHA1Utils.toHexStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            log.error("Failed calculate digest for message={}", (Object)message, (Object)e);
            return "";
        }
    }

    private static String toHexStr(byte[] b) {
        StringBuffer sb = new StringBuffer(36);
        for (int i = 0; i < b.length; ++i) {
            int n = b[i] & 0xFF;
            int hb = n >> 4;
            int lb = n % 16;
            sb.append(HEX_CHARS[hb]).append(HEX_CHARS[lb]);
        }
        return sb.toString();
    }
}

