/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.impl;

import com.google.common.collect.Maps;
import com.kuaike.skynet.link.service.PushService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.logic.service.common.WechatCommonService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatCommmonServiceImpl
implements WechatCommonService {
    private static final Logger log = LoggerFactory.getLogger(WechatCommmonServiceImpl.class);
    @Autowired
    private PushService pushService;

    @Override
    public Map<String, Boolean> queryWechatStatus(List<String> wechatIds) {
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Maps.newHashMap();
        }
        BaseResponse resp = this.pushService.queryWechatsStatus(wechatIds);
        if (resp.getCode() != 0L) {
            log.warn("query wechat status failed. wechatIds={}, resp={}", wechatIds, (Object)resp);
            return Maps.newHashMap();
        }
        List statusList = (List)resp.getData();
        return statusList.stream().collect(Collectors.toMap(it -> it.getWId(), it -> it.isOnline()));
    }
}

