/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.impl;

import com.google.common.base.Objects;
import com.kuaike.skynet.logic.dal.common.entity.Setting;
import com.kuaike.skynet.logic.dal.common.mapper.SettingMapper;
import com.kuaike.skynet.logic.service.common.SettingService;
import com.kuaike.skynet.logic.service.common.enums.MultipleKeywordStrategy;
import com.kuaike.skynet.logic.service.common.enums.SystemParamName;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    @Autowired
    private SettingMapper settingMapper;
    @Qualifier(value="defaultMap")
    @Autowired
    private Map<String, String> defaultMap;

    @Override
    public String getSettingValue(SystemParamName paramName, Long businessCustomerId) {
        String value = null;
        try {
            value = this.settingMapper.getParamValueByName(paramName.getKey(), businessCustomerId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query setting with businessCustomerId={}, paramName={}", new Object[]{businessCustomerId, paramName, e});
        }
        if (value == null && (value = this.defaultMap.get(paramName.getKey())) != null) {
            Setting record = new Setting();
            record.setBusinessCustomerId(businessCustomerId);
            record.setParamValue(value);
            record.setParamName(paramName.getKey());
            record.setDescription(paramName.getDesc());
            record.setModule("\u5546\u6237\u53c2\u6570");
            record.setCreatedBy(Long.valueOf(-1L));
            record.setLastUpdatedBy(Long.valueOf(-1L));
            this.settingMapper.insertSelective((Object)record);
        }
        return value;
    }

    @Override
    public Integer getFriendSendIntervalTime(Long businessCustomerId) {
        String minIntervalStr = this.getSettingValue(SystemParamName.minFriendWelcomeInterval, businessCustomerId);
        String maxIntervalStr = this.getSettingValue(SystemParamName.maxFriendWelcomeInterval, businessCustomerId);
        int minInterval = Integer.parseInt(minIntervalStr == null ? "3" : minIntervalStr);
        int maxInterval = Integer.parseInt(maxIntervalStr == null ? "10" : maxIntervalStr);
        int interval = new Double((double)minInterval + Math.random() * (double)(maxInterval - minInterval)).intValue();
        return interval;
    }

    @Override
    public Integer getGroupSendIntervalTime(Long businessCustomerId) {
        String minIntervalStr = this.getSettingValue(SystemParamName.minChatRoomWelcomeInterval, businessCustomerId);
        String maxIntervalStr = this.getSettingValue(SystemParamName.maxChatRoomWelcomeInterval, businessCustomerId);
        int minInterval = Integer.parseInt(minIntervalStr == null ? "30" : minIntervalStr);
        int maxInterval = Integer.parseInt(maxIntervalStr == null ? "50" : maxIntervalStr);
        int interval = new Double((double)minInterval + Math.random() * (double)(maxInterval - minInterval)).intValue();
        return interval;
    }

    @Override
    public Integer getMemberIntervalNum(Long businessCustomerId) {
        String memberIntervalStr = this.getSettingValue(SystemParamName.chatRoomWelcomeIntervalNum, businessCustomerId);
        int memberInterval = Integer.parseInt(memberIntervalStr == null ? "3" : memberIntervalStr);
        return memberInterval;
    }

    @Override
    public boolean isAtMember(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.autoReplyReplyCall, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public boolean isReferText(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.autoReplyContainsQuestion, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public boolean isReferFriendText(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.friendAutoReplyContainsQuestion, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public boolean needAtRobot(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.autoReplyNeedCall, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public MultipleKeywordStrategy getGroupMultipleKeywordStrategy(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.groupMultipleKeywordStrategy, businessCustomerId);
        MultipleKeywordStrategy strategy = null;
        try {
            strategy = MultipleKeywordStrategy.getType(Integer.parseInt(value));
            if (strategy == null) {
                strategy = MultipleKeywordStrategy.REPLY_OPTION;
                log.warn("Unsupported gruop multiple keyword strategy, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Failed parsing gruop multiple keyword strategy, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            strategy = MultipleKeywordStrategy.REPLY_OPTION;
        }
        return strategy;
    }

    @Override
    public boolean getGroupReplyDeduplicateEnabled(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.groupReplyDeduplicateEnabled, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public Integer getGroupReplyDeduplicateTime(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.groupReplyDeduplicateTime, businessCustomerId);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            log.warn("Failed parsing group reply deduplicate time, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            return 0;
        }
    }

    @Override
    public MultipleKeywordStrategy getFriendMultipleKeywordStrategy(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.friendMultipleKeywordStrategy, businessCustomerId);
        MultipleKeywordStrategy strategy = null;
        try {
            strategy = MultipleKeywordStrategy.getType(Integer.parseInt(value));
            if (strategy == null) {
                strategy = MultipleKeywordStrategy.REPLY_OPTION;
                log.warn("Unsupported friend multiple keyword strategy, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Failed parsing friend multiple keyword strategy, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            strategy = MultipleKeywordStrategy.REPLY_OPTION;
        }
        return strategy;
    }

    @Override
    public boolean getFriendReplyDeduplicateEnabled(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.friendReplyDeduplicateEnabled, businessCustomerId);
        return Objects.equal((Object)value, (Object)"1");
    }

    @Override
    public Integer getFriendReplyDeduplicateTime(Long businessCustomerId) {
        String value = this.getSettingValue(SystemParamName.friendReplyDeduplicateTime, businessCustomerId);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            log.warn("Failed parsing friend reply deduplicate time, value={}, businessCustomerId={}", (Object)value, (Object)businessCustomerId);
            return 0;
        }
    }
}

