/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MaterialTypeEnum {
    TXT("text", "\u6587\u672c"),
    IMAGE("image", "\u56fe\u7247"),
    VOICE("voice", "\u8bed\u97f3"),
    VIDEO("video", "\u89c6\u9891"),
    NEWS("news", "\u56fe\u6587"),
    FILE("file", "\u6587\u4ef6");

    private static final Map<String, MaterialTypeEnum> MAP;
    private final String value;
    private final String desc;

    private MaterialTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static MaterialTypeEnum getType(String value) {
        return MAP.get(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getValueByDesc(String desc) {
        for (MaterialTypeEnum type : MAP.values()) {
            if (!type.getDesc().equals(desc)) continue;
            return type.getValue();
        }
        return null;
    }

    public static String getDescByValue(String value) {
        MaterialTypeEnum type = MaterialTypeEnum.getType(value);
        if (type != null) {
            return type.getDesc();
        }
        return null;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(MaterialTypeEnum.values()).collect(Collectors.toMap(MaterialTypeEnum::getValue, Function.identity())));
    }
}

