/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.common;

import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class VersionedCache
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(VersionedCache.class);
    protected boolean initialized = false;
    protected String version = "";
    @Autowired
    protected RedisTemplate<String, Object> redisTemplate;

    public void run(String ... args) throws Exception {
        this.initialized = true;
        this.refresh();
    }

    protected abstract String getVersionRedisKey();

    protected abstract Long getExpiredInSecond();

    protected abstract void initialize();

    private String initVersion() {
        String redisKey = this.getVersionRedisKey();
        String version = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpiredInSecond();
            Boolean ok = expire != null && expire > 0L ? this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)version, Duration.ofSeconds(expire)) : this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)version);
            if (ok != null && ok.booleanValue()) {
                log.info("Cache version initialized, key:{}, value:{}, expire:{}", new Object[]{redisKey, version, expire});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed init cache version, key:{}, value:{}", new Object[]{redisKey, version, e});
        }
        return version;
    }

    private String getCurrentVersion() {
        String redisKey = this.getVersionRedisKey();
        String version = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)redisKey);
        version = obj == null ? this.initVersion() : (String)obj;
        return version;
    }

    protected void reset() {
        String redisKey = this.getVersionRedisKey();
        String version = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpiredInSecond();
            if (expire != null && expire > 0L) {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)version, Duration.ofSeconds(expire));
            } else {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)version);
            }
            log.info("Set new cache version, key:{}, value:{}, expire:{}", new Object[]{redisKey, version, expire});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to create new version", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (!this.initialized) {
            return;
        }
        String version = this.getCurrentVersion();
        VersionedCache versionedCache = this;
        synchronized (versionedCache) {
            if (this.version.equals(version)) {
                return;
            }
            this.version = version;
            long time = System.currentTimeMillis();
            this.initialize();
            time = System.currentTimeMillis() - time;
            log.info("{} cache refreshed in {}ms", (Object)this.getClass().getSimpleName(), (Object)time);
        }
    }
}

