package cn.kinyun.scrm.weixin.sdk.entity.user.resp;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.entity.user.resp
 * @date Date : 2019年04月26日 11:29
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class UserInfo extends ErrorCode {
    private static final long serialVersionUID = -9155341202420030900L;

    /**
     * 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息
     */
    private int subscribe;

    /**
     * 用户的标识，对当前公众号唯一
     */
    @JsonAlias("openid")
    private String openId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 性别
     */
    private int sex;

    /**
     * 用户语言
     */
    private String language;

    /**
     * 用户所在城市
     */
    private String city;

    /**
     * 用户所在省份
     */
    private String province;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
     */
    @JsonAlias("headimgurl")
    private String headImgUrl;

    /**
     * 用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
     */
    @JsonAlias("subscribe_time")
    private long subscribeTime;

    /**
     * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。
     */
    @JsonAlias("unionid")
    private String unionId;

    /**
     * 公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
     */
    private String remark;

    /**
     * 用户所在的分组ID（兼容旧的用户分组接口）
     */
    @JsonAlias("groupid")
    private long groupId;

    /**
     * 用户被打上的标签ID列表
     */
    @JsonAlias("tagid_list")
    private List<Long> tagIdList;

    /**
     * 返回用户关注的渠道来源，<br/>
     * ADD_SCENE_SEARCH 公众号搜索，<br/>
     * ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，<br/>
     * ADD_SCENE_PROFILE_CARD 名片分享，<br/>
     * ADD_SCENE_QR_CODE 扫描二维码，<br/>
     * ADD_SCENEPROFILE LINK 图文页内名称点击，<br/>
     * ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，<br/>
     * ADD_SCENE_PAID 支付后关注，<br/>
     * ADD_SCENE_OTHERS 其他<br/>
     */
    @JsonAlias("subscribe_scene")
    private String subscribeScene;

    /**
     * 二维码扫码场景（开发者自定义）
     */
    @JsonAlias("qr_scene")
    private long qrScene;

    /**
     * 二维码扫码场景描述（开发者自定义）
     */
    @JsonAlias("qr_scene_str")
    private String qrSceneStr;

}
